/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.server;

import com.mojang.authlib.GameProfile;
import java.util.IllegalFormatException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import org.vivecraft.server.ServerNetworking;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={ServerPlayer.class})
public abstract class ServerPlayerMixin
extends Player {
    @Shadow
    @Final
    public MinecraftServer f_8924_;

    public ServerPlayerMixin(Level level, BlockPos blockPos, float f, GameProfile gameProfile) {
        super(level, blockPos, f, gameProfile);
    }

    @Inject(at={@At(value="TAIL")}, method={"initInventoryMenu"})
    public void vivecraft$menu(CallbackInfo ci) {
        ServerVivePlayer serverviveplayer = this.vivecraft$getVivePlayer();
        if (((Boolean)ServerConfig.vrFun.get()).booleanValue() && serverviveplayer != null && serverviveplayer.isVR() && this.f_19796_.m_188503_(40) == 3) {
            ItemStack itemstack = this.f_19796_.m_188503_(2) == 1 ? new ItemStack((ItemLike)Items.f_42687_).m_41714_((Component)Component.m_237113_((String)"EAT ME")) : PotionUtils.m_43549_((ItemStack)new ItemStack((ItemLike)Items.f_42589_), (Potion)Potions.f_43599_).m_41714_((Component)Component.m_237113_((String)"DRINK ME"));
            itemstack.m_41783_().m_128405_("HideFlags", 32);
            if (this.m_150109_().m_36054_(itemstack)) {
                this.f_36095_.m_38946_();
            }
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;tick()V", shift=At.Shift.AFTER)}, method={"doTick()V"})
    public void vivecraft$tick(CallbackInfo info) {
        ServerVRPlayers.overridePose((ServerPlayer)this);
    }

    public void m_36346_() {
        ServerVivePlayer serverviveplayer = this.vivecraft$getVivePlayer();
        if (serverviveplayer != null && serverviveplayer.isVR()) {
            Vec3 vec3 = serverviveplayer.getControllerDir(0);
            float f = (float)Math.toDegrees(Math.atan2(vec3.f_82479_, -vec3.f_82481_));
            double d0 = -Mth.m_14031_((float)(f * ((float)Math.PI / 180)));
            double d1 = Mth.m_14089_((float)(f * ((float)Math.PI / 180)));
            Vec3 vec31 = serverviveplayer.getControllerPos(0, this);
            if (this.m_9236_() instanceof ServerLevel) {
                ((ServerLevel)this.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123766_, vec31.f_82479_ + d0, vec31.f_82480_, vec31.f_82481_ + d1, 0, d0, 0.0, d1, 0.0);
            }
        } else {
            super.m_36346_();
        }
    }

    protected void m_21137_(ItemStack pStack, int pCount) {
        if (!pStack.m_41619_() && this.m_6117_()) {
            if (pStack.m_41780_() == UseAnim.DRINK) {
                this.m_5496_(this.m_7838_(pStack), 0.5f, this.m_9236_().f_46441_.m_188501_() * 0.1f + 0.9f);
            }
            if (pStack.m_41780_() == UseAnim.EAT) {
                this.vivecraft$addItemParticles(pStack, pCount);
                this.m_5496_(this.m_7866_(pStack), 0.5f + 0.5f * (float)this.f_19796_.m_188503_(2), (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
            }
        }
    }

    @Unique
    private void vivecraft$addItemParticles(ItemStack stack, int count) {
        ServerVivePlayer serverviveplayer = this.vivecraft$getVivePlayer();
        for (int i = 0; i < count; ++i) {
            Vec3 vec3 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vec3 = vec3.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            double d0 = (double)(-this.f_19796_.m_188501_()) * 0.6 - 0.3;
            Vec3 vec31 = new Vec3(((double)this.f_19796_.m_188501_() - 0.5) * 0.3, d0, 0.6);
            vec31 = vec31.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            vec31 = vec31.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            if (serverviveplayer != null && serverviveplayer.isVR()) {
                InteractionHand interactionhand = this.m_7655_();
                vec31 = interactionhand == InteractionHand.MAIN_HAND ? serverviveplayer.getControllerPos(0, this) : serverviveplayer.getControllerPos(1, this);
            }
            this.m_9236_().m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
    }

    @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z", shift=At.Shift.BEFORE)}, method={"drop(Lnet/minecraft/world/item/ItemStack;ZZ)Lnet/minecraft/world/entity/item/ItemEntity;"}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void vivecraft$dropvive(ItemStack p_9085_, boolean dropAround, boolean includeName, CallbackInfoReturnable<ItemEntity> info, ItemEntity itementity) {
        ServerVivePlayer serverviveplayer = this.vivecraft$getVivePlayer();
        if (serverviveplayer != null && serverviveplayer.isVR() && !dropAround) {
            Vec3 vec3 = serverviveplayer.getControllerPos(0, this);
            Vec3 vec31 = serverviveplayer.getControllerDir(0);
            float f = 0.3f;
            itementity.m_20334_(vec31.f_82479_ * (double)f, vec31.f_82480_ * (double)f, vec31.f_82481_ * (double)f);
            itementity.m_6034_(vec3.m_7096_() + itementity.m_20184_().m_7096_(), vec3.m_7098_() + itementity.m_20184_().m_7098_(), vec3.m_7094_() + itementity.m_20184_().m_7094_());
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"hurt"}, cancellable=true)
    public void vivecraft$checkCanGetHurt(DamageSource damageSource, float f, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = damageSource.m_7639_();
        ServerPlayer other = null;
        if (entity instanceof ServerPlayer) {
            other = (ServerPlayer)entity;
        } else if (entity instanceof AbstractArrow && ((AbstractArrow)entity).m_19749_() instanceof ServerPlayer) {
            other = (ServerPlayer)((AbstractArrow)entity).m_19749_();
        }
        if (other != null) {
            ServerVivePlayer otherVive = ServerVRPlayers.getVivePlayer(other);
            ServerVivePlayer thisVive = this.vivecraft$getVivePlayer();
            if (otherVive == null) {
                otherVive = new ServerVivePlayer(other);
            }
            if (thisVive == null) {
                thisVive = new ServerVivePlayer((ServerPlayer)this);
            }
            boolean blockedDamage = false;
            String blockedDamageCase = "";
            if (!otherVive.isVR() && thisVive.isVR() && thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.pvpSEATEDVRvsNONVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled nonvr vs seated VR damage";
                }
            } else if (!otherVive.isVR() && thisVive.isVR() && !thisVive.isSeated() || !thisVive.isVR() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.pvpVRvsNONVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled nonvr vs standing VR damage";
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated() || thisVive.isVR() && thisVive.isSeated() && otherVive.isVR() && !otherVive.isSeated()) {
                if (!((Boolean)ServerConfig.pvpVRvsSEATEDVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled seated VR vs standing VR damage";
                }
            } else if (otherVive.isVR() && !otherVive.isSeated() && thisVive.isVR() && !thisVive.isSeated()) {
                if (!((Boolean)ServerConfig.pvpVRvsVR.get()).booleanValue()) {
                    blockedDamage = true;
                    blockedDamageCase = "canceled standing VR vs standing VR damage";
                }
            } else if (otherVive.isVR() && otherVive.isSeated() && thisVive.isVR() && thisVive.isSeated() && !((Boolean)ServerConfig.pvpSEATEDVRvsSEATEDVR.get()).booleanValue()) {
                blockedDamage = true;
                blockedDamageCase = "canceled seated VR vs seated VR damage";
            }
            if (blockedDamage) {
                if (((Boolean)ServerConfig.pvpNotifyBlockedDamage.get()).booleanValue()) {
                    other.m_213846_((Component)Component.m_237113_((String)blockedDamageCase));
                }
                cir.setReturnValue((Object)false);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"die"})
    private void vivecraft$customDeathMessage(DamageSource damageSource, CallbackInfo ci) {
        if (((Boolean)ServerConfig.messagesEnabled.get()).booleanValue()) {
            ServerVivePlayer vivePlayer = ServerVRPlayers.getVivePlayer((ServerPlayer)this);
            String message = "";
            String entity = "";
            if (damageSource.m_7639_() != null) {
                entity = damageSource.m_7639_().m_7755_().m_6879_().getString();
                message = vivePlayer == null ? (String)ServerConfig.messagesDeathByMobVanilla.get() : (!vivePlayer.isVR() ? (String)ServerConfig.messagesDeathByMobNonVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.messagesDeathByMobSeated.get() : (String)ServerConfig.messagesDeathByMobVR.get()));
            }
            if (message.isEmpty()) {
                message = vivePlayer == null ? (String)ServerConfig.messagesDeathVanilla.get() : (!vivePlayer.isVR() ? (String)ServerConfig.messagesDeathNonVR.get() : (vivePlayer.isSeated() ? (String)ServerConfig.messagesDeathSeated.get() : (String)ServerConfig.messagesDeathVR.get()));
            }
            if (!message.isEmpty()) {
                try {
                    this.f_8924_.m_6846_().m_240416_((Component)Component.m_237113_((String)message.formatted(this.m_7755_().getString(), entity)), false);
                }
                catch (IllegalFormatException e) {
                    ServerNetworking.LOGGER.error("Death message '{}' has errors: {}", (Object)message, (Object)e.toString());
                }
            }
        }
    }

    @Unique
    private ServerVivePlayer vivecraft$getVivePlayer() {
        return ServerVRPlayers.getVivePlayer((ServerPlayer)this);
    }
}

