/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mixin.world.entity.projectile;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.vivecraft.common.utils.Utils;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Entity {
    @Shadow
    private double f_36698_;

    protected AbstractArrowMixin(EntityType<? extends Projectile> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
    }

    @Inject(at={@At(value="RETURN")}, method={"<init>(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/level/Level;)V"})
    public void vivecraft$pickup(EntityType<? extends AbstractArrow> p_36717_, LivingEntity p_36718_, Level p_36719_, CallbackInfo info) {
        ServerPlayer player;
        ServerVivePlayer serverviveplayer;
        if (p_36718_ instanceof ServerPlayer && (serverviveplayer = ServerVRPlayers.getVivePlayer(player = (ServerPlayer)p_36718_)) != null && serverviveplayer.isVR()) {
            Vec3 vec3 = serverviveplayer.getControllerPos(serverviveplayer.activeHand, (Player)p_36718_);
            Vec3 vec31 = serverviveplayer.getControllerDir(serverviveplayer.activeHand);
            if (!serverviveplayer.isSeated() && serverviveplayer.getDraw() > 0.0f) {
                vec31 = serverviveplayer.getControllerPos(1, (Player)p_36718_).m_82546_(serverviveplayer.getControllerPos(0, (Player)p_36718_)).m_82541_();
                vec3 = serverviveplayer.getControllerPos(0, (Player)p_36718_);
            }
            this.m_6034_(vec3.f_82479_ + vec31.f_82479_, vec3.f_82480_ + vec31.f_82480_, vec3.f_82481_ + vec31.f_82481_);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onHitEntity"})
    public void vivecraft$damageMultiplier(EntityHitResult entityHitResult, CallbackInfo ci) {
        Entity entity = ((Projectile)this).m_19749_();
        if (entity instanceof ServerPlayer) {
            ServerPlayer owner = (ServerPlayer)entity;
            ServerVivePlayer serverVivePlayer = ServerVRPlayers.getVivePlayer(owner);
            double multiplier = 1.0;
            Vec3 hitpos = this.vivecraft$isHeadshot(entityHitResult);
            if (hitpos != null) {
                multiplier = serverVivePlayer != null && serverVivePlayer.isVR() ? (serverVivePlayer.isSeated() ? ((Double)ServerConfig.bowSeatedHeadshotMultiplier.get()).doubleValue() : ((Double)ServerConfig.bowStandingHeadshotMultiplier.get()).doubleValue()) : (Double)ServerConfig.bowVanillaHeadshotMultiplier.get();
                if (multiplier > 1.0) {
                    ((ServerLevel)this.m_9236_()).m_8624_(owner, (ParticleOptions)ParticleTypes.f_123797_, true, hitpos.f_82479_, hitpos.f_82480_, hitpos.f_82481_, 5, -this.m_20184_().f_82479_, -this.m_20184_().f_82480_, -this.m_20184_().f_82481_, 0.1);
                    owner.f_8906_.m_9829_((Packet)new ClientboundSoundPacket(BuiltInRegistries.f_256894_.m_263177_((Object)SoundEvents.f_12018_), SoundSource.PLAYERS, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), 0.7f, 0.5f, owner.m_9236_().f_46441_.m_188505_()));
                }
            }
            if (serverVivePlayer != null && serverVivePlayer.isVR()) {
                multiplier = serverVivePlayer.isSeated() ? Math.max(multiplier, (Double)ServerConfig.bowSeatedMultiplier.get()) : Math.max(multiplier, (Double)ServerConfig.bowStandingMultiplier.get());
            }
            this.f_36698_ *= multiplier;
        }
    }

    @Unique
    private Vec3 vivecraft$isHeadshot(EntityHitResult hit) {
        AABB headBox = Utils.getEntityHeadHitbox(hit.m_82443_(), 0.3);
        if (headBox != null) {
            Vec3 originalHitpos = hit.m_82443_().m_20191_().m_82371_(this.m_20182_(), this.m_20182_().m_82549_(this.m_20184_().m_82490_(2.0))).orElse(this.m_20182_().m_82549_(this.m_20184_()));
            return headBox.m_82371_(this.m_20182_(), originalHitpos).orElse(headBox.m_82390_(this.m_20182_()) ? this.m_20182_() : null);
        }
        return null;
    }
}

