/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.mod_compat_vr.optifine;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.client_vr.settings.VRSettings;

public class OptifineHelper {
    private static boolean checkedForOptifine = false;
    private static boolean optifineLoaded = false;
    private static Class<?> optifineConfig;
    private static Method optifineConfigIsShadersMethod;
    private static Method optifineConfigIsRenderRegionsMethod;
    private static Method optifineConfigIsSkyEnabledMethod;
    private static Method optifineConfigIsSunMoonEnabledMethod;
    private static Method optifineConfigIsStarsEnabledMethod;
    private static Method optifineConfigIsCustomColorsMethod;
    private static Method optifineConfigIsAntialiasingMethod;
    private static Method optifineConfigIsAntialiasingConfiguredMethod;
    private static Class<?> smartAnimations;
    private static Method smartAnimationsSpriteRenderedMethod;
    private static Class<?> customColors;
    private static Method customColorsGetSkyColorMethod;
    private static Method customColorsGetSkyColoEndMethod;
    private static Method customColorsGetUnderwaterColorMethod;
    private static Method customColorsGetUnderlavaColorMethod;
    private static Method customColorsGetFogColorMethod;
    private static Method customColorsGetFogColorEndMethod;
    private static Method customColorsGetFogColorNetherMethod;
    private static Class<?> shadersRender;
    private static Method shadersRenderBeginOutlineMethod;
    private static Method shadersRenderEndOutlineMethod;
    private static Class<?> shaders;
    private static Method shadersBeginEntitiesMethod;
    private static Method shadersEndEntitiesMethod;
    private static Field shadersDFB;
    private static Method shadersFramebufferBindFramebuffer;
    private static Field optionsOfRenderRegions;
    private static Field optionsOfCloudHeight;
    private static Field optionsOfAoLevel;
    private static Field vertexRenderPositions;

    public static boolean isOptifineLoaded() {
        if (!checkedForOptifine) {
            checkedForOptifine = true;
            try {
                Class.forName("net.optifine.Config");
                VRSettings.logger.info("Vivecraft: Optifine detected");
                optifineLoaded = true;
            }
            catch (ClassNotFoundException ignore) {
                VRSettings.logger.info("Vivecraft: Optifine not detected");
                optifineLoaded = false;
            }
            if (optifineLoaded) {
                OptifineHelper.init();
            }
        }
        return optifineLoaded;
    }

    public static boolean isShaderActive() {
        try {
            return (Boolean)optifineConfigIsShadersMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean bindShaderFramebuffer() {
        try {
            Object dfb = shadersDFB.get(shaders);
            if (dfb != null) {
                shadersFramebufferBindFramebuffer.invoke(dfb, new Object[0]);
                return true;
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void beginOutlineShader() {
        try {
            shadersRenderBeginOutlineMethod.invoke(shadersRender, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void endOutlineShader() {
        try {
            shadersRenderEndOutlineMethod.invoke(shadersRender, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void beginEntities() {
        try {
            shadersBeginEntitiesMethod.invoke(shaders, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void endEntities() {
        try {
            shadersEndEntitiesMethod.invoke(shaders, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static boolean isSunMoonEnabled() {
        try {
            return (Boolean)optifineConfigIsSunMoonEnabledMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isSkyEnabled() {
        try {
            return (Boolean)optifineConfigIsSkyEnabledMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isStarsEnabled() {
        try {
            return (Boolean)optifineConfigIsStarsEnabledMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isCustomColors() {
        try {
            return (Boolean)optifineConfigIsCustomColorsMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isRenderRegions() {
        try {
            return (Boolean)optifineConfigIsRenderRegionsMethod.invoke(optifineConfig, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isAntialiasing() {
        try {
            return (Boolean)optifineConfigIsAntialiasingMethod.invoke(optifineConfig, new Object[0]) != false || (Boolean)optifineConfigIsAntialiasingConfiguredMethod.invoke(optifineConfig, new Object[0]) != false;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setRenderRegions(boolean active) {
        try {
            optionsOfRenderRegions.set(Minecraft.m_91087_().f_91066_, active);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public static Vec3 getCustomSkyColor(Vec3 skyColor, BlockAndTintGetter blockAccess, double x, double y, double z) {
        try {
            return (Vec3)customColorsGetSkyColorMethod.invoke(customColors, skyColor, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return skyColor;
        }
    }

    public static Vec3 getCustomSkyColorEnd(Vec3 skyColor) {
        try {
            return (Vec3)customColorsGetSkyColoEndMethod.invoke(customColors, skyColor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return skyColor;
        }
    }

    public static Vec3 getCustomUnderwaterColor(BlockAndTintGetter blockAccess, double x, double y, double z) {
        try {
            return (Vec3)customColorsGetUnderwaterColorMethod.invoke(customColors, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Vec3 getCustomUnderlavaColor(BlockAndTintGetter blockAccess, double x, double y, double z) {
        try {
            return (Vec3)customColorsGetUnderlavaColorMethod.invoke(customColors, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Vec3 getCustomFogColor(Vec3 fogColor, BlockAndTintGetter blockAccess, double x, double y, double z) {
        try {
            return (Vec3)customColorsGetFogColorMethod.invoke(customColors, fogColor, blockAccess, x, y, z);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return fogColor;
        }
    }

    public static Vec3 getCustomFogColorEnd(Vec3 fogColor) {
        try {
            return (Vec3)customColorsGetFogColorEndMethod.invoke(customColors, fogColor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return fogColor;
        }
    }

    public static Vec3 getCustomFogColorNether(Vec3 fogColor) {
        try {
            return (Vec3)customColorsGetFogColorNetherMethod.invoke(customColors, fogColor);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
            return fogColor;
        }
    }

    public static double getCloudHeight() {
        try {
            return (Double)optionsOfCloudHeight.get(Minecraft.m_91087_().f_91066_);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 0.0;
        }
    }

    public static double getAoLevel() {
        try {
            return (Double)optionsOfAoLevel.get(Minecraft.m_91087_().f_91066_);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return 1.0;
        }
    }

    public static void markTextureAsActive(TextureAtlasSprite sprite) {
        try {
            smartAnimationsSpriteRenderedMethod.invoke(smartAnimations, sprite);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    public static void copyRenderPositions(ModelPart.Vertex source, ModelPart.Vertex dest) {
        if (vertexRenderPositions != null) {
            try {
                vertexRenderPositions.set(dest, vertexRenderPositions.get(source));
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static void init() {
        try {
            optifineConfig = Class.forName("net.optifine.Config");
            optifineConfigIsShadersMethod = optifineConfig.getMethod("isShaders", new Class[0]);
            optifineConfigIsRenderRegionsMethod = optifineConfig.getMethod("isRenderRegions", new Class[0]);
            optifineConfigIsSkyEnabledMethod = optifineConfig.getMethod("isSkyEnabled", new Class[0]);
            optifineConfigIsSunMoonEnabledMethod = optifineConfig.getMethod("isSunMoonEnabled", new Class[0]);
            optifineConfigIsStarsEnabledMethod = optifineConfig.getMethod("isStarsEnabled", new Class[0]);
            optifineConfigIsCustomColorsMethod = optifineConfig.getMethod("isCustomColors", new Class[0]);
            optifineConfigIsAntialiasingMethod = optifineConfig.getMethod("isAntialiasing", new Class[0]);
            optifineConfigIsAntialiasingConfiguredMethod = optifineConfig.getMethod("isAntialiasingConfigured", new Class[0]);
            smartAnimations = Class.forName("net.optifine.SmartAnimations");
            smartAnimationsSpriteRenderedMethod = smartAnimations.getMethod("spriteRendered", TextureAtlasSprite.class);
            optionsOfRenderRegions = Options.class.getField("ofRenderRegions");
            optionsOfCloudHeight = Options.class.getField("ofCloudsHeight");
            optionsOfAoLevel = Options.class.getField("ofAoLevel");
            customColors = Class.forName("net.optifine.CustomColors");
            customColorsGetSkyColorMethod = customColors.getMethod("getSkyColor", Vec3.class, BlockAndTintGetter.class, Double.TYPE, Double.TYPE, Double.TYPE);
            customColorsGetUnderwaterColorMethod = customColors.getMethod("getUnderwaterColor", BlockAndTintGetter.class, Double.TYPE, Double.TYPE, Double.TYPE);
            customColorsGetUnderlavaColorMethod = customColors.getMethod("getUnderlavaColor", BlockAndTintGetter.class, Double.TYPE, Double.TYPE, Double.TYPE);
            shadersRender = Class.forName("net.optifine.shaders.ShadersRender");
            shadersRenderBeginOutlineMethod = shadersRender.getMethod("beginOutline", new Class[0]);
            shadersRenderEndOutlineMethod = shadersRender.getMethod("endOutline", new Class[0]);
            shaders = Class.forName("net.optifine.shaders.Shaders");
            shadersBeginEntitiesMethod = shaders.getMethod("beginEntities", new Class[0]);
            shadersEndEntitiesMethod = shaders.getMethod("endEntities", new Class[0]);
            Class<?> shadersFramebuffer = Class.forName("net.optifine.shaders.ShadersFramebuffer");
            shadersFramebufferBindFramebuffer = shadersFramebuffer.getMethod("bindFramebuffer", new Class[0]);
            customColorsGetSkyColoEndMethod = customColors.getDeclaredMethod("getSkyColorEnd", Vec3.class);
            customColorsGetSkyColoEndMethod.setAccessible(true);
            customColorsGetFogColorMethod = customColors.getDeclaredMethod("getFogColor", Vec3.class, BlockAndTintGetter.class, Double.TYPE, Double.TYPE, Double.TYPE);
            customColorsGetFogColorMethod.setAccessible(true);
            customColorsGetFogColorEndMethod = customColors.getDeclaredMethod("getFogColorEnd", Vec3.class);
            customColorsGetFogColorEndMethod.setAccessible(true);
            customColorsGetFogColorNetherMethod = customColors.getDeclaredMethod("getFogColorNether", Vec3.class);
            customColorsGetFogColorNetherMethod.setAccessible(true);
            shadersDFB = shaders.getDeclaredField("dfb");
            shadersDFB.setAccessible(true);
            try {
                vertexRenderPositions = ModelPart.Vertex.class.getField("renderPositions");
            }
            catch (NoSuchFieldException e) {
                vertexRenderPositions = null;
            }
        }
        catch (ClassNotFoundException e) {
            VRSettings.logger.error("Optifine detected, but couldn't load class: {}", (Object)e.getMessage());
            optifineLoaded = false;
        }
        catch (NoSuchMethodException e) {
            VRSettings.logger.error("Optifine detected, but couldn't load Method: {}", (Object)e.getMessage());
            optifineLoaded = false;
        }
        catch (NoSuchFieldException e) {
            VRSettings.logger.error("Optifine detected, but couldn't load Field: {}", (Object)e.getMessage());
        }
    }
}

