/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import io.netty.buffer.Unpooled;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.chunk.ChunkSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.vivecraft.common.CommonDataHolder;
import org.vivecraft.common.network.CommonNetworkHelper;
import org.vivecraft.common.network.Pose;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.mixin.server.ChunkMapAccessor;
import org.vivecraft.mixin.server.TrackedEntityAccessor;
import org.vivecraft.server.ServerVRPlayers;
import org.vivecraft.server.ServerVivePlayer;
import org.vivecraft.server.config.ServerConfig;

public class ServerNetworking {
    private static final Map<UUID, Map<CommonNetworkHelper.PacketDiscriminators, FriendlyByteBuf>> legacyDataMap = new HashMap<UUID, Map<CommonNetworkHelper.PacketDiscriminators, FriendlyByteBuf>>();
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"VivecraftServer");

    /*
     * Unable to fully structure code
     */
    public static void handlePacket(CommonNetworkHelper.PacketDiscriminators packetID, FriendlyByteBuf buffer, ServerPlayer player, Consumer<ClientboundCustomPayloadPacket> packetConsumer) {
        vivePlayer = ServerVRPlayers.getVivePlayer(player);
        if (vivePlayer == null && packetID != CommonNetworkHelper.PacketDiscriminators.VERSION) {
            return;
        }
        switch (1.$SwitchMap$org$vivecraft$common$network$CommonNetworkHelper$PacketDiscriminators[packetID.ordinal()]) {
            case 1: {
                vivePlayer = new ServerVivePlayer(player);
                stringBytes = new byte[buffer.readableBytes()];
                buffer.readBytes(stringBytes);
                parts = new String(stringBytes).split("\\n");
                clientVivecraftVersion = parts[0];
                if (((Boolean)ServerConfig.debug.get()).booleanValue()) {
                    ServerNetworking.LOGGER.info("Vivecraft: player '{}' joined with {}", (Object)player.m_7755_().getString(), (Object)clientVivecraftVersion);
                }
                if (parts.length < 3) ** GOTO lbl26
                clientMaxVersion = Integer.parseInt(parts[1]);
                clientMinVersion = Integer.parseInt(parts[2]);
                if (0 <= clientMaxVersion && clientMinVersion <= 0) {
                    vivePlayer.networkVersion = Math.min(clientMaxVersion, 0);
                    if (((Boolean)ServerConfig.debug.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("{} networking supported, using version {}", (Object)player.m_7755_().getString(), (Object)vivePlayer.networkVersion);
                    }
                } else {
                    player.m_213846_((Component)Component.m_237113_((String)"Unsupported vivecraft version, VR features will not work"));
                    if (((Boolean)ServerConfig.debug.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("{} networking not supported. client range [{},{}], server range [{},{}]", new Object[]{player.m_7755_().getString(), clientMinVersion, clientMaxVersion, 0, 0});
                    }
                    return;
lbl26:
                    // 1 sources

                    vivePlayer.networkVersion = -1;
                    if (((Boolean)ServerConfig.debug.get()).booleanValue()) {
                        ServerNetworking.LOGGER.info("{} using legacy networking", (Object)player.m_7755_().getString());
                    }
                }
                vivePlayer.setVR(clientVivecraftVersion.contains("NONVR") == false);
                ServerVRPlayers.getPlayersWithVivecraft(player.f_8924_).put(player.m_20148_(), vivePlayer);
                packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.VERSION, CommonDataHolder.getInstance().versionIdentifier));
                packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.REQUESTDATA, new byte[0]));
                if (((Boolean)ServerConfig.climbeyEnabled.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getClimbeyServerPacket());
                }
                if (((Boolean)ServerConfig.teleportEnabled.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.TELEPORT, new byte[0]));
                }
                if (((Boolean)ServerConfig.teleportLimitedSurvival.get()).booleanValue()) {
                    byteBuf = new FriendlyByteBuf(Unpooled.buffer());
                    byteBuf.m_130070_("limitedTeleport");
                    byteBuf.m_130070_("true");
                    byteBuf.m_130070_("teleportLimitUp");
                    byteBuf.m_130070_("" + ServerConfig.teleportUpLimit.get());
                    byteBuf.m_130070_("teleportLimitDown");
                    byteBuf.m_130070_("" + ServerConfig.teleportDownLimit.get());
                    byteBuf.m_130070_("teleportLimitHoriz");
                    byteBuf.m_130070_("" + ServerConfig.teleportHorizontalLimit.get());
                    array = new byte[byteBuf.readableBytes()];
                    byteBuf.readBytes(array);
                    byteBuf.release();
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.SETTING_OVERRIDE, array));
                }
                if (((Boolean)ServerConfig.worldscaleLimited.get()).booleanValue()) {
                    byteBuf = new FriendlyByteBuf(Unpooled.buffer());
                    byteBuf.m_130070_("worldScale.min");
                    byteBuf.m_130070_("" + ServerConfig.worldscaleMin.get());
                    byteBuf.m_130070_("worldScale.max");
                    byteBuf.m_130070_("" + ServerConfig.worldscaleMax.get());
                    array = new byte[byteBuf.readableBytes()];
                    byteBuf.readBytes(array);
                    byteBuf.release();
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.SETTING_OVERRIDE, array));
                }
                if (((Boolean)ServerConfig.forceThirdPersonItems.get()).booleanValue()) {
                    byteBuf = new FriendlyByteBuf(Unpooled.buffer());
                    byteBuf.m_130070_("thirdPersonItems");
                    byteBuf.m_130070_("true");
                    array = new byte[byteBuf.readableBytes()];
                    byteBuf.readBytes(array);
                    byteBuf.release();
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.SETTING_OVERRIDE, array));
                }
                if (((Boolean)ServerConfig.forceThirdPersonItemsCustom.get()).booleanValue()) {
                    byteBuf = new FriendlyByteBuf(Unpooled.buffer());
                    byteBuf.m_130070_("thirdPersonItemsCustom");
                    byteBuf.m_130070_("true");
                    array = new byte[byteBuf.readableBytes()];
                    byteBuf.readBytes(array);
                    byteBuf.release();
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.SETTING_OVERRIDE, array));
                }
                if (((Boolean)ServerConfig.crawlingEnabled.get()).booleanValue()) {
                    packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.CRAWL, new byte[0]));
                }
                packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.VR_SWITCHING, new byte[]{(byte)((Boolean)ServerConfig.vrSwitchingEnabled.get() != false && (Boolean)ServerConfig.vr_only.get() == false)}));
                packetConsumer.accept(ServerNetworking.getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators.NETWORK_VERSION, new byte[]{(byte)vivePlayer.networkVersion}));
                break;
            }
            case 2: {
                if (vivePlayer.isVR() == buffer.readBoolean()) break;
                vivePlayer.setVR(vivePlayer.isVR() == false);
                if (vivePlayer.isVR()) break;
                for (ServerPlayerConnection trackingPlayer : ServerNetworking.getTrackingPlayers((Entity)player)) {
                    if (!ServerVRPlayers.getPlayersWithVivecraft(player.f_8924_).containsKey(trackingPlayer.m_142253_().m_20148_()) || trackingPlayer.m_142253_() == player) continue;
                    trackingPlayer.m_9829_((Packet)ServerNetworking.createVRActivePlayerPacket(false, player.m_20148_()));
                }
                break;
            }
            case 3: {
                vivePlayer.draw = buffer.readFloat();
                break;
            }
            case 4: {
                vivePlayer.vrPlayerState = VrPlayerState.deserialize(buffer);
            }
            default: {
                break;
            }
            case 7: {
                vivePlayer.worldScale = buffer.readFloat();
                break;
            }
            case 8: {
                vivePlayer.heightScale = buffer.readFloat();
                break;
            }
            case 9: {
                f = buffer.readFloat();
                f1 = buffer.readFloat();
                f2 = buffer.readFloat();
                player.m_19890_((double)f, (double)f1, (double)f2, player.m_146908_(), player.m_146909_());
                break;
            }
            case 10: {
                player.f_19789_ = 0.0f;
                break;
            }
            case 11: {
                vivePlayer.activeHand = buffer.readByte();
                if (!vivePlayer.isSeated()) break;
                vivePlayer.activeHand = 0;
                break;
            }
            case 12: {
                v0 = vivePlayer.crawling = buffer.readByte() != 0;
                if (!vivePlayer.crawling) break;
                player.m_20124_(net.minecraft.world.entity.Pose.SWIMMING);
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                playerData = ServerNetworking.legacyDataMap.get(player.m_20148_());
                if (playerData == null) {
                    playerData = new HashMap<CommonNetworkHelper.PacketDiscriminators, FriendlyByteBuf>();
                    ServerNetworking.legacyDataMap.put(player.m_20148_(), playerData);
                }
                buffer.retain();
                playerData.put(packetID, buffer);
                if (playerData.size() != 3) break;
                controller0Data = playerData.get((Object)CommonNetworkHelper.PacketDiscriminators.CONTROLLER0DATA);
                controller0Data.resetReaderIndex().readByte();
                controller1Data = playerData.get((Object)CommonNetworkHelper.PacketDiscriminators.CONTROLLER1DATA);
                controller1Data.resetReaderIndex().readByte();
                headData = playerData.get((Object)CommonNetworkHelper.PacketDiscriminators.HEADDATA);
                headData.resetReaderIndex().readByte();
                vivePlayer.vrPlayerState = new VrPlayerState(headData.readBoolean(), Pose.deserialize(headData), controller0Data.readBoolean(), Pose.deserialize(controller0Data), controller1Data.readBoolean(), Pose.deserialize(controller1Data));
                headData.release();
                controller0Data.release();
                controller1Data.release();
                ServerNetworking.legacyDataMap.remove(player.m_20148_());
            }
        }
    }

    public static Set<ServerPlayerConnection> getTrackingPlayers(Entity entity) {
        ChunkSource manager = entity.m_9236_().m_7726_();
        ChunkMap storage = ((ServerChunkCache)manager).f_8325_;
        TrackedEntityAccessor playerTracker = (TrackedEntityAccessor)((ChunkMapAccessor)storage).getTrackedEntities().get(entity.m_19879_());
        return playerTracker != null ? playerTracker.getPlayersTracking() : Collections.emptySet();
    }

    public static ClientboundCustomPayloadPacket createVRActivePlayerPacket(boolean vrActive, UUID playerID) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.IS_VR_ACTIVE.ordinal());
        buffer.writeBoolean(vrActive);
        buffer.m_130077_(playerID);
        return new ClientboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static ClientboundCustomPayloadPacket createUberPacket(Player player, VrPlayerState vrPlayerState, float worldScale, float heightScale) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeByte(CommonNetworkHelper.PacketDiscriminators.UBERPACKET.ordinal());
        buffer.m_130077_(player.m_20148_());
        vrPlayerState.serialize(buffer);
        buffer.writeFloat(worldScale);
        buffer.writeFloat(heightScale);
        return new ClientboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static ClientboundCustomPayloadPacket getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators command, byte[] payload) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeByte(command.ordinal());
        buffer.writeBytes(payload);
        return new ClientboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static ClientboundCustomPayloadPacket getClimbeyServerPacket() {
        FriendlyByteBuf friendlybytebuf = new FriendlyByteBuf(Unpooled.buffer());
        friendlybytebuf.writeByte(CommonNetworkHelper.PacketDiscriminators.CLIMBING.ordinal());
        friendlybytebuf.writeBoolean(true);
        if (!"DISABLED".equals(ServerConfig.climbeyBlockmode.get())) {
            if ("WHITELIST".equals(ServerConfig.climbeyBlockmode.get())) {
                friendlybytebuf.writeByte(1);
            } else {
                friendlybytebuf.writeByte(2);
            }
            for (String block : (List)ServerConfig.climbeyBlocklist.get()) {
                friendlybytebuf.m_130070_(block);
            }
        } else {
            friendlybytebuf.writeByte(0);
        }
        return new ClientboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, friendlybytebuf);
    }

    public static ClientboundCustomPayloadPacket getVivecraftServerPacket(CommonNetworkHelper.PacketDiscriminators command, String payload) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        buffer.writeByte(command.ordinal());
        buffer.m_130070_(payload);
        return new ClientboundCustomPayloadPacket(CommonNetworkHelper.CHANNEL, buffer);
    }

    public static void sendVrPlayerStateToClients(ServerPlayer vrPlayerEntity) {
        Map<UUID, ServerVivePlayer> playersWithVivecraft = ServerVRPlayers.getPlayersWithVivecraft(vrPlayerEntity.f_8924_);
        ServerVivePlayer vivePlayer = playersWithVivecraft.get(vrPlayerEntity.m_20148_());
        if (vivePlayer == null) {
            return;
        }
        if (vivePlayer.player == null || vivePlayer.player.m_9232_()) {
            playersWithVivecraft.remove(vrPlayerEntity.m_20148_());
        }
        if (!vivePlayer.isVR() || vivePlayer.vrPlayerState == null) {
            return;
        }
        for (ServerPlayerConnection trackingPlayer : ServerNetworking.getTrackingPlayers((Entity)vrPlayerEntity)) {
            if (!playersWithVivecraft.containsKey(trackingPlayer.m_142253_().m_20148_()) || trackingPlayer.m_142253_() == vrPlayerEntity) continue;
            trackingPlayer.m_9829_((Packet)ServerNetworking.createUberPacket((Player)vivePlayer.player, vivePlayer.vrPlayerState, vivePlayer.worldScale, vivePlayer.heightScale));
        }
    }
}

