/*
 * Decompiled with CFR 0.152.
 */
package org.vivecraft.server;

import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.vivecraft.common.network.Pose;
import org.vivecraft.common.network.VrPlayerState;
import org.vivecraft.common.utils.math.Vector3;

public class ServerVivePlayer {
    @Nullable
    public VrPlayerState vrPlayerState;
    public float draw;
    public float worldScale = 1.0f;
    public float heightScale = 1.0f;
    public byte activeHand = 0;
    public boolean crawling;
    private boolean isVR = false;
    public Vec3 offset = new Vec3(0.0, 0.0, 0.0);
    public ServerPlayer player;
    final Vector3 forward = new Vector3(0.0f, 0.0f, -1.0f);
    public int networkVersion = 0;

    public ServerVivePlayer(ServerPlayer player) {
        this.player = player;
    }

    public float getDraw() {
        return this.draw;
    }

    public Vec3 getControllerVectorCustom(int controller, Vector3 direction) {
        Pose controllerPose;
        if (this.isSeated()) {
            controller = 0;
        }
        Pose pose = controllerPose = controller == 0 ? this.vrPlayerState.controller0() : this.vrPlayerState.controller1();
        if (controllerPose != null) {
            Vector3 vector3 = controllerPose.orientation().multiply(direction);
            return new Vec3((double)vector3.getX(), (double)vector3.getY(), (double)vector3.getZ());
        }
        return this.player.m_20154_();
    }

    public Vec3 getControllerDir(int controller) {
        return this.getControllerVectorCustom(controller, this.forward);
    }

    public Vec3 getHMDDir() {
        if (this.vrPlayerState != null) {
            Vector3 vector3 = this.vrPlayerState.hmd().orientation().multiply(this.forward);
            return new Vec3((double)vector3.getX(), (double)vector3.getY(), (double)vector3.getZ());
        }
        return this.player.m_20154_();
    }

    public Vec3 getHMDPos(Player player) {
        if (this.vrPlayerState != null) {
            return this.vrPlayerState.hmd().position().m_82549_(player.m_20182_()).m_82549_(this.offset);
        }
        return player.m_20182_().m_82520_(0.0, 1.62, 0.0);
    }

    public Vec3 getControllerPos(int c, Player player, boolean realPosition) {
        if (this.vrPlayerState != null) {
            if (this.isSeated() && !realPosition) {
                Vec3 vec3 = this.getHMDDir();
                vec3 = vec3.m_82524_((float)Math.toRadians(c == 0 ? -35.0 : 35.0));
                vec3 = new Vec3(vec3.f_82479_, 0.0, vec3.f_82481_);
                vec3 = vec3.m_82541_();
                return this.getHMDPos(player).m_82520_(vec3.f_82479_ * 0.3 * (double)this.worldScale, -0.4 * (double)this.worldScale, vec3.f_82481_ * 0.3 * (double)this.worldScale);
            }
            Pose controllerState = c == 0 ? this.vrPlayerState.controller0() : this.vrPlayerState.controller1();
            return controllerState.position().m_82549_(player.m_20182_()).m_82549_(this.offset);
        }
        return player.m_20182_().m_82520_(0.0, 1.62, 0.0);
    }

    public Vec3 getControllerPos(int c, Player player) {
        return this.getControllerPos(c, player, false);
    }

    public boolean isVR() {
        return this.isVR;
    }

    public void setVR(boolean vr) {
        this.isVR = vr;
    }

    public boolean isSeated() {
        if (this.vrPlayerState == null) {
            return false;
        }
        return this.vrPlayerState.seated();
    }
}

