/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.content.kinetics.base.IRotate;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.item.TooltipHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.OreDataCapability;
import com.tom.createores.Registration;
import com.tom.createores.block.entity.IDrill;
import com.tom.createores.block.entity.MultiblockCapHandler;
import com.tom.createores.client.ClientUtil;
import com.tom.createores.item.OreVeinAtlasItem;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.recipe.VeinRecipe;
import com.tom.createores.util.DimChunkPos;
import com.tom.createores.util.NumberFormatter;
import java.util.Comparator;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public abstract class ExcavatingBlockEntity<R extends ExcavatingRecipe>
extends SmartBlockEntity
implements MultiblockCapHandler,
IDrill {
    protected int progress;
    protected MultiblockCapHandler.Kinetic kinetic;
    protected ResourceLocation veinClient;
    protected ResourceLocation recipeClient;
    protected long resourceRemClient;
    protected boolean hasRotation;
    protected ItemStack drillStack;
    protected R current;
    protected VeinRecipe vein;
    protected OreDataCapability.OreData data;
    protected ExcavatorState state = ExcavatorState.NO_VEIN;
    protected boolean completedOneCycle;

    protected ExcavatingBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.drillStack = ItemStack.f_41583_;
        this.setLazyTickRate(20);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        VeinRecipe veinR = this.veinClient != null ? (VeinRecipe)this.f_58857_.m_7465_().m_44043_(this.veinClient).filter(e -> e instanceof VeinRecipe).map(r -> (VeinRecipe)r).orElse(null) : null;
        Component vein = veinR != null ? veinR.getName() : Component.m_237115_((String)"chat.coe.veinFinder.nothing");
        ExcavatingRecipe rec = this.recipeClient != null ? (ExcavatingRecipe)this.f_58857_.m_7465_().m_44043_(this.recipeClient).filter(r -> r.m_6671_() == this.getRecipeType()).map(r -> (ExcavatingRecipe)r).orElse(null) : null;
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237110_((String)"chat.coe.veinFinder.found", (Object[])new Object[]{vein})));
        if (!this.hasRotation) {
            tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)Lang.translateDirect((String)"tooltip.speedRequirement", (Object[])new Object[0]).m_130940_(ChatFormatting.GOLD)));
            MutableComponent hint = Lang.translateDirect((String)"gui.contraptions.not_fast_enough", (Object[])new Object[]{I18n.m_118938_((String)this.m_58900_().m_60734_().m_7705_(), (Object[])new Object[0])});
            List cutString = TooltipHelper.cutTextComponent((Component)hint, (TooltipHelper.Palette)TooltipHelper.Palette.GRAY_AND_WHITE);
            for (int i = 0; i < cutString.size(); ++i) {
                tooltip.add((Component)componentSpacing.m_6879_().m_7220_((Component)cutString.get(i)));
            }
        }
        if (this.drillStack.m_41619_()) {
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"info.coe.drill.noDrill")));
        } else {
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237110_((String)"info.coe.drill.installed", (Object[])new Object[]{this.drillStack.m_41786_()})));
        }
        if (!this.f_58857_.m_8055_(this.getBelow()).m_60838_((BlockGetter)this.f_58857_, this.getBelow())) {
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"info.coe.drill.noGround")));
        }
        if (rec != null) {
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"info.coe.drill.progress")).m_130946_(": [").m_7220_(ClientUtil.makeProgressBar((float)this.progress / (float)rec.getTicks())).m_130946_("]"));
            if (this.resourceRemClient != 0L) {
                tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237110_((String)"info.coe.drill.resourceRemaining", (Object[])new Object[]{NumberFormatter.formatNumber(this.resourceRemClient)})));
            }
            if (!rec.getDrill().test(this.drillStack)) {
                tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"info.coe.drill.badDrill")));
            }
            this.addToGoggleTooltip(tooltip, rec);
        }
        if (this.state != ExcavatorState.NO_ERROR) {
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)("info.coe.drill.err_" + this.state.name().toLowerCase()))));
        }
        return true;
    }

    public void addToGoggleTooltip(List<Component> tooltip, R recipe) {
    }

    public void updateRecipe() {
        this.vein = null;
        this.current = null;
        ChunkPos p = new ChunkPos(this.f_58858_);
        this.data = OreDataCapability.getData(this.f_58857_.m_6325_(p.f_45578_, p.f_45579_));
        RecipeManager m = this.f_58857_.m_7465_();
        if (this.data != null) {
            this.vein = this.data.getRecipe(m);
            if (this.vein != null) {
                List<ExcavatingRecipe> rec = m.m_44013_(this.getRecipeType()).stream().filter(r -> r.veinId.equals((Object)this.vein.m_6423_())).sorted(Comparator.comparingInt(r -> r.priority)).toList();
                if (rec.size() == 1) {
                    this.current = rec.get(0);
                } else if (rec.size() > 1) {
                    for (ExcavatingRecipe r2 : rec) {
                        if (!this.validateRecipe(r2)) continue;
                        this.current = r2;
                    }
                    if (this.current == null) {
                        this.current = rec.get(0);
                    }
                }
            }
        }
    }

    protected boolean validateRecipe(R recipe) {
        return ((ExcavatingRecipe)recipe).getDrill().test(this.drillStack);
    }

    protected abstract RecipeType<R> getRecipeType();

    protected abstract boolean canExtract();

    protected abstract void onFinished();

    public void tick() {
        super.tick();
        if (!this.f_58857_.f_46443_) {
            if (this.current != null && this.state == ExcavatorState.NO_ERROR) {
                if (this.kinetic != null) {
                    this.kinetic.setStress(((ExcavatingRecipe)this.current).getStress());
                }
                if (this.canExtract() && this.kinetic != null && this.kinetic.getRotationSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue() && ((ExcavatingRecipe)this.current).getDrill().test(this.drillStack) && this.f_58857_.m_8055_(this.getBelow()).m_60838_((BlockGetter)this.f_58857_, this.getBelow())) {
                    float prg = this.kinetic.getRotationSpeed() / IRotate.SpeedLevel.MEDIUM.getSpeedValue();
                    this.progress = (int)((float)this.progress + prg);
                    if (this.progress >= ((ExcavatingRecipe)this.current).getTicks()) {
                        this.updateState();
                        if (this.state == ExcavatorState.NO_ERROR) {
                            this.onFinished();
                            this.data.extract(1);
                            this.completedOneCycle = true;
                        }
                        this.progress = 0;
                    }
                } else if (!((ExcavatingRecipe)this.current).getDrill().test(this.drillStack)) {
                    R old = this.current;
                    this.updateRecipe();
                    if (old != this.current) {
                        this.progress = 0;
                    }
                }
            } else if (this.progress > 10) {
                this.progress = 0;
                this.updateState();
            } else {
                ++this.progress;
            }
        }
    }

    private void updateState() {
        this.updateRecipe();
        this.state = this.vein == null ? ExcavatorState.NO_VEIN : (!this.data.canExtract(this.f_58857_, this.f_58858_) ? ExcavatorState.TOO_MANY_EXCAVATORS : (this.data.getResourcesRemaining(this.vein) == -1L ? ExcavatorState.VEIN_EMPTY : (this.current == null ? ExcavatorState.NO_RECIPE : ExcavatorState.NO_ERROR)));
        this.notifyUpdate();
    }

    public void lazyTick() {
        this.notifyUpdate();
    }

    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.progress = tag.m_128451_("progress");
        this.drillStack = ItemStack.m_41712_((CompoundTag)tag.m_128469_("drill"));
        this.completedOneCycle = tag.m_128471_("finishedOnce");
        if (clientPacket) {
            this.state = ExcavatorState.VALUES[tag.m_128445_("state")];
            if (tag.m_128441_("veinId")) {
                this.veinClient = new ResourceLocation(tag.m_128461_("veinId"));
                this.resourceRemClient = tag.m_128454_("resRem");
            } else {
                this.veinClient = null;
            }
            this.recipeClient = tag.m_128441_("currentRecipeId") ? new ResourceLocation(tag.m_128461_("currentRecipeId")) : null;
            this.hasRotation = tag.m_128471_("hasRot");
        }
    }

    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128405_("progress", this.progress);
        tag.m_128365_("drill", (Tag)this.drillStack.m_41739_(new CompoundTag()));
        tag.m_128379_("finishedOnce", this.completedOneCycle);
        if (clientPacket) {
            tag.m_128344_("state", (byte)this.state.ordinal());
            if (this.vein != null) {
                tag.m_128359_("veinId", this.vein.m_6423_().toString());
                tag.m_128356_("resRem", this.data.getResourcesRemaining(this.vein));
            }
            if (this.current != null) {
                tag.m_128359_("currentRecipeId", ((ExcavatingRecipe)this.current).m_6423_().toString());
            }
            tag.m_128379_("hasRot", this.kinetic != null && this.kinetic.getRotationSpeed() >= IRotate.SpeedLevel.MEDIUM.getSpeedValue());
        }
    }

    public void initialize() {
        super.initialize();
        if (!this.f_58857_.f_46443_) {
            if (this.progress > 0 && this.current == null) {
                this.updateRecipe();
            }
            if (this.current == null) {
                this.progress = 0;
            }
        }
    }

    @Override
    public ItemStack getDrill() {
        return this.drillStack;
    }

    @Override
    public BlockPos getBelow() {
        return this.f_58858_.m_6625_(2);
    }

    @Override
    public void addKinetic(MultiblockCapHandler.Kinetic k) {
        this.kinetic = k;
    }

    @Override
    public void dropInv() {
        this.dropItemStack(this.drillStack);
    }

    public InteractionResult onClick(Player player, InteractionHand hand) {
        ItemStack item = player.m_21120_(hand);
        if (item.m_41720_() == Registration.VEIN_ATLAS_ITEM.get()) {
            if (!this.f_58857_.f_46443_) {
                if (this.completedOneCycle) {
                    ((OreVeinAtlasItem)Registration.VEIN_ATLAS_ITEM.get()).addVein(player, item, this.vein, new DimChunkPos(this.f_58857_, this.f_58858_), this.data.getRandomMul());
                } else {
                    player.m_5661_((Component)Component.m_237115_((String)"chat.coe.sampleDrill.notDone"), true);
                }
            }
            return InteractionResult.SUCCESS;
        }
        if (!item.m_41619_() && item.m_204117_(CreateOreExcavation.DRILL_TAG)) {
            if (this.drillStack.m_41619_()) {
                if (!this.f_58857_.f_46443_) {
                    this.drillStack = item.m_41620_(1);
                }
                this.notifyUpdate();
                return InteractionResult.SUCCESS;
            }
        } else if (item.m_41619_() && !this.drillStack.m_41619_()) {
            if (!this.f_58857_.f_46443_) {
                if (player.m_36356_(this.drillStack)) {
                    this.drillStack = ItemStack.f_41583_;
                    this.notifyUpdate();
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    protected void dropItemStack(ItemStack stackInSlot) {
        Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)stackInSlot);
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(this.f_58858_.m_7918_(-1, -1, -1), this.f_58858_.m_7918_(1, 0, 1));
    }

    @Override
    public Direction getFacing() {
        return (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
    }

    @Override
    public boolean shouldRenderRubble() {
        return this.completedOneCycle || this.recipeClient != null && this.progress > 0;
    }

    @Override
    public float getYOffset() {
        return 0.8f;
    }

    @Override
    public float getDrillOffset() {
        return this.isActive() ? 0.2f : 0.0f;
    }

    private boolean isActive() {
        return this.recipeClient != null && this.hasRotation;
    }

    @Override
    public float getRotation() {
        if (this.isActive()) {
            long ticks = this.m_58904_().m_46467_();
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public float getPrevRotation() {
        if (this.isActive()) {
            long ticks = this.m_58904_().m_46467_() - 1L;
            float rot = ticks * 20L % 360L;
            return rot;
        }
        return 0.0f;
    }

    @Override
    public boolean shouldRenderShaft() {
        return true;
    }

    public static enum ExcavatorState {
        NO_ERROR,
        NO_VEIN,
        VEIN_EMPTY,
        TOO_MANY_EXCAVATORS,
        NO_RECIPE;

        public static final ExcavatorState[] VALUES;

        static {
            VALUES = ExcavatorState.values();
        }
    }
}

