/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.tom.createores.block.entity.ExcavatingBlockEntity;
import com.tom.createores.recipe.ExcavatingRecipe;
import com.tom.createores.util.IOBlockType;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public abstract class ExcavatingBlockEntityImpl<R extends ExcavatingRecipe>
extends ExcavatingBlockEntity<R> {
    protected FluidTank fluidTank = new FluidTank(16000){

        protected void onContentsChanged() {
            ExcavatingBlockEntityImpl.this.notifyUpdate();
        }
    };
    protected LazyOptional<FluidTank> tankCap = LazyOptional.of(() -> this.fluidTank);

    protected ExcavatingBlockEntityImpl(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public <T> LazyOptional<T> getCaps(Capability<T> cap, IOBlockType type) {
        if (type == IOBlockType.FLUID_IN && cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.tankCap.cast();
        }
        return LazyOptional.empty();
    }

    @Override
    protected void read(CompoundTag tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        this.fluidTank.readFromNBT(tag.m_128469_(this.getTankInName()));
    }

    @Override
    protected void write(CompoundTag tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        tag.m_128365_(this.getTankInName(), (Tag)this.fluidTank.writeToNBT(new CompoundTag()));
    }

    @Override
    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"info.coe.drill.fluidInfo")));
        this.containedFluidTooltip(tooltip, isPlayerSneaking, this.tankCap.cast());
        return true;
    }

    @Override
    public void addToGoggleTooltip(List<Component> tooltip, R rec) {
        if (!(((ExcavatingRecipe)rec).getDrillingFluid().getRequiredAmount() == 0 || ((ExcavatingRecipe)rec).getDrillingFluid().test(this.fluidTank.getFluid()) && this.fluidTank.getFluidAmount() >= ((ExcavatingRecipe)rec).getDrillingFluid().getRequiredAmount())) {
            tooltip.add((Component)Component.m_237113_((String)"    ").m_7220_((Component)Component.m_237115_((String)"info.coe.drill.noFluid")));
        }
    }

    @Override
    protected boolean validateRecipe(R recipe) {
        return super.validateRecipe(recipe) && (((ExcavatingRecipe)recipe).getDrillingFluid().getRequiredAmount() == 0 || ((ExcavatingRecipe)recipe).getDrillingFluid().test(this.fluidTank.getFluid()));
    }

    public void invalidate() {
        super.invalidate();
        this.tankCap.invalidate();
    }

    @Override
    protected boolean canExtract() {
        return this.current.getDrillingFluid().getRequiredAmount() == 0 || this.current.getDrillingFluid().test(this.fluidTank.getFluid()) && this.fluidTank.getFluidAmount() >= this.current.getDrillingFluid().getRequiredAmount();
    }

    @Override
    protected void onFinished() {
        this.fluidTank.drain(this.current.getDrillingFluid().getRequiredAmount(), IFluidHandler.FluidAction.EXECUTE);
    }

    protected String getTankInName() {
        return "tank";
    }
}

