/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.client.gui.book.widget;

import com.github.alexmodguy.alexscaves.client.gui.book.CaveBookScreen;
import com.github.alexmodguy.alexscaves.client.gui.book.widget.BookWidget;
import com.github.alexmodguy.alexscaves.client.render.ACRenderTypes;
import com.github.alexmodguy.alexscaves.client.render.item.ACItemstackRenderer;
import com.google.gson.annotations.Expose;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Axis;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.registries.ForgeRegistries;

public class ItemWidget
extends BookWidget {
    @Expose
    private String item;
    @Expose
    private String nbt;
    @Expose
    private boolean sepia;
    @Expose(serialize=false, deserialize=false)
    private ItemStack actualItem = ItemStack.f_41583_;
    private static final RenderType SEPIA_ITEM_RENDER_TYPE = ACRenderTypes.getBookWidget(TextureAtlas.f_118259_, true);

    public ItemWidget(int displayPage, String item, String nbt, boolean sepia, int x, int y, float scale) {
        super(displayPage, BookWidget.Type.ITEM, x, y, scale);
        this.item = item;
        this.nbt = nbt;
        this.sepia = sepia;
    }

    @Override
    public void render(PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, float partialTicks, boolean onFlippingPage) {
        if (this.actualItem == null && this.item != null) {
            this.actualItem = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(new ResourceLocation(this.item)));
            if (this.nbt != null && !this.nbt.isEmpty()) {
                CompoundTag tag = null;
                try {
                    tag = TagParser.m_129359_((String)this.nbt);
                }
                catch (CommandSyntaxException e) {
                    e.printStackTrace();
                }
                this.actualItem.m_41751_(tag);
            }
        }
        float scale = 16.0f * this.getScale();
        poseStack.m_85836_();
        poseStack.m_252880_((float)this.getX(), (float)this.getY(), 0.0f);
        poseStack.m_252880_(0.0f, 0.0f, 50.0f);
        ItemWidget.renderItem(this.actualItem, poseStack, bufferSource, this.sepia, scale);
        poseStack.m_85849_();
    }

    public static void renderItem(ItemStack itemStack, PoseStack poseStack, MultiBufferSource.BufferSource bufferSource, boolean sepia, float scale) {
        if (itemStack == null) {
            return;
        }
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(itemStack, (Level)Minecraft.m_91087_().f_91073_, null, 0);
        poseStack.m_85836_();
        try {
            poseStack.m_85841_(scale, scale, scale);
            CaveBookScreen.fixLighting();
            if (!sepia) {
                poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
                poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            } else {
                poseStack.m_252781_(Axis.f_252393_.m_252977_(180.0f));
                poseStack.m_85841_(-1.0f, 1.0f, 1.0f);
                ACItemstackRenderer.sepiaFlag = true;
            }
            if (sepia && !bakedmodel.m_7521_()) {
                ItemWidget.renderSepiaItem(poseStack, bakedmodel, itemStack, bufferSource);
            } else {
                Minecraft.m_91087_().m_91291_().m_115143_(itemStack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)bufferSource, 240, OverlayTexture.f_118083_, bakedmodel);
            }
            if (sepia) {
                ACItemstackRenderer.sepiaFlag = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        poseStack.m_85849_();
    }

    public static void renderSepiaItem(PoseStack poseStack, BakedModel bakedmodel, ItemStack itemStack, MultiBufferSource.BufferSource bufferSource) {
        poseStack.m_85836_();
        bakedmodel = ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)bakedmodel, (ItemDisplayContext)ItemDisplayContext.GUI, (boolean)false);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        for (RenderType rt : bakedmodel.getRenderTypes(itemStack, false)) {
            ItemWidget.renderModel(poseStack.m_85850_(), bufferSource.m_6299_(SEPIA_ITEM_RENDER_TYPE), 1.0f, null, bakedmodel, 1.0f, 1.0f, 1.0f, 240, OverlayTexture.f_118083_, ModelData.EMPTY, rt);
        }
        poseStack.m_85849_();
    }

    private static void renderModel(PoseStack.Pose p_111068_, VertexConsumer p_111069_, float alpha, @Nullable BlockState p_111070_, BakedModel p_111071_, float p_111072_, float p_111073_, float p_111074_, int p_111075_, int p_111076_, ModelData modelData, RenderType renderType) {
        RandomSource randomsource = RandomSource.m_216327_();
        long i = 42L;
        for (Direction direction : Direction.values()) {
            randomsource.m_188584_(42L);
            ItemWidget.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, alpha, p_111071_.getQuads(p_111070_, direction, randomsource, modelData, renderType), p_111075_, p_111076_);
        }
        randomsource.m_188584_(42L);
        ItemWidget.renderQuadList(p_111068_, p_111069_, p_111072_, p_111073_, p_111074_, alpha, p_111071_.getQuads(p_111070_, (Direction)null, randomsource, modelData, renderType), p_111075_, p_111076_);
    }

    private static void renderQuadList(PoseStack.Pose p_111059_, VertexConsumer p_111060_, float p_111061_, float p_111062_, float p_111063_, float alpha, List<BakedQuad> p_111064_, int p_111065_, int p_111066_) {
        for (BakedQuad bakedquad : p_111064_) {
            float f = Mth.m_14036_((float)p_111061_, (float)0.0f, (float)1.0f);
            float f1 = Mth.m_14036_((float)p_111062_, (float)0.0f, (float)1.0f);
            float f2 = Mth.m_14036_((float)p_111063_, (float)0.0f, (float)1.0f);
            p_111060_.putBulkData(p_111059_, bakedquad, new float[]{1.0f, 1.0f, 1.0f, 1.0f}, f, f1, f2, alpha, new int[]{p_111065_, p_111065_, p_111065_, p_111065_}, p_111066_, false);
        }
    }
}

