/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.level.structure;

import com.github.alexmodguy.alexscaves.server.level.biome.ACBiomeRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.ACStructureRegistry;
import com.github.alexmodguy.alexscaves.server.level.structure.piece.VolcanoStructurePiece;
import com.github.alexmodguy.alexscaves.server.misc.ACMath;
import com.mojang.serialization.Codec;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class VolcanoStructure
extends Structure {
    public static final int VOLCANO_Y_CENTER = -34;
    public static final Codec<VolcanoStructure> CODEC = VolcanoStructure.m_226607_(settings -> new VolcanoStructure((Structure.StructureSettings)settings));

    protected VolcanoStructure(Structure.StructureSettings settings) {
        super(settings);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        int i = context.f_226628_().m_151382_(9);
        int j = context.f_226628_().m_151391_(9);
        for (Holder<Biome> holder : ACMath.getBiomesWithinAtY(context.f_226623_(), i, -34, j, 30, context.f_226624_().m_224579_())) {
            if (holder.m_203565_(ACBiomeRegistry.PRIMORDIAL_CAVES)) continue;
            return Optional.empty();
        }
        return this.atYCaveBiomePoint(context, Heightmap.Types.OCEAN_FLOOR_WG, builder -> this.generatePieces((StructurePiecesBuilder)builder, context));
    }

    protected Optional<Structure.GenerationStub> atYCaveBiomePoint(Structure.GenerationContext context, Heightmap.Types heightMap, Consumer<StructurePiecesBuilder> builderConsumer) {
        ChunkPos chunkpos = context.f_226628_();
        int i = chunkpos.m_151390_();
        int j = chunkpos.m_151393_();
        int k = -1;
        return Optional.of(new Structure.GenerationStub(new BlockPos(i, k, j), builderConsumer));
    }

    public void generatePieces(StructurePiecesBuilder builder, Structure.GenerationContext context) {
        WorldgenRandom worldgenrandom = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        worldgenrandom.m_190068_(context.f_226627_(), context.f_226628_().f_45578_, context.f_226628_().f_45579_);
        int volcanoWidthRadius = 30 + context.f_226626_().m_188503_(15);
        int volcanoHeight = volcanoWidthRadius + 8 + context.f_226626_().m_188503_(5);
        int i = context.f_226628_().m_45604_();
        int j = context.f_226628_().m_45605_();
        int k = context.f_226622_().m_6337_();
        BlockPos xzCoords = new BlockPos(i, -34, j);
        int widthChunks = (int)Math.ceil((float)volcanoWidthRadius / 16.0f);
        for (int chunkX = -widthChunks; chunkX <= widthChunks; ++chunkX) {
            for (int chunkZ = -widthChunks; chunkZ <= widthChunks; ++chunkZ) {
                BlockPos offset = xzCoords.m_7918_(chunkX * 16, 0, chunkZ * 16);
                builder.m_142679_((StructurePiece)new VolcanoStructurePiece(xzCoords, offset, volcanoWidthRadius, volcanoHeight));
            }
        }
    }

    public GenerationStep.Decoration m_226619_() {
        return GenerationStep.Decoration.UNDERGROUND_STRUCTURES;
    }

    public StructureType<?> m_213658_() {
        return (StructureType)ACStructureRegistry.VOLCANO.get();
    }
}

