/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.forge;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.furnace.FurnaceFuelBurnTimeEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.potionstudios.biomeswevegone.util.BoneMealHandler;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGTradesConfig;
import net.potionstudios.biomeswevegone.world.entity.npc.BWGVillagerTrades;
import net.potionstudios.biomeswevegone.world.item.tools.ToolInteractions;
import net.potionstudios.biomeswevegone.world.level.block.BWGBlocks;
import net.potionstudios.biomeswevegone.world.level.block.BlockFeatures;
import net.potionstudios.biomeswevegone.world.level.levelgen.biome.BWGBiomes;
import net.potionstudios.biomeswevegone.world.level.levelgen.feature.placed.BWGOverworldVegationPlacedFeatures;
import org.apache.logging.log4j.util.TriConsumer;

public class VanillaCompatForge {
    public static void init() {
        ToolInteractions.registerStrippableBlocks((block, stripped) -> {
            AxeItem.f_150683_ = new HashMap(AxeItem.f_150683_);
            AxeItem.f_150683_.put(block, stripped);
        });
        BlockFeatures.registerFlammable((TriConsumer<Block, Integer, Integer>)((TriConsumer)(arg_0, arg_1, arg_2) -> ((FireBlock)((FireBlock)Blocks.f_50083_)).m_53444_(arg_0, arg_1, arg_2)));
        BlockFeatures.registerCompostables((item, chance) -> ComposterBlock.m_51920_((float)chance.floatValue(), (ItemLike)item));
        ToolInteractions.registerFlattenables(ShovelItem.f_43110_::put);
    }

    public static void registerVanillaCompatEvents(IEventBus bus) {
        bus.addListener(VanillaCompatForge::registerTillables);
        bus.addListener(VanillaCompatForge::registerFuels);
        if (BWGTradesConfig.INSTANCE.get().enableTrades()) {
            bus.addListener(VanillaCompatForge::onVillagerTrade);
        }
        bus.addListener(VanillaCompatForge::onBoneMealUse);
    }

    private static void registerTillables(BlockEvent.BlockToolModificationEvent event) {
        if (event.getToolAction() == ToolActions.HOE_TILL && event.getLevel().m_8055_(event.getPos().m_7494_()).m_60795_()) {
            BlockState state = event.getState();
            if (state.m_60713_((Block)BWGBlocks.LUSH_GRASS_BLOCK.get()) || state.m_60713_(BWGBlocks.LUSH_DIRT.get())) {
                event.setFinalState(BWGBlocks.LUSH_FARMLAND.get().m_49966_());
            } else if (state.m_60713_(BWGBlocks.SANDY_DIRT.get())) {
                event.setFinalState(BWGBlocks.SANDY_FARMLAND.get().m_49966_());
            } else if (state.m_60713_(BWGBlocks.PEAT.get())) {
                event.setFinalState(Blocks.f_50093_.m_49966_());
            }
        }
    }

    private static void registerFuels(FurnaceFuelBurnTimeEvent event) {
        if (event.getItemStack().m_150930_(BWGBlocks.PEAT.get().m_5456_())) {
            event.setBurnTime(1200);
        }
    }

    private static void onVillagerTrade(VillagerTradesEvent event) {
        if (BWGVillagerTrades.TRADES.containsKey(event.getType())) {
            Int2ObjectMap trades = event.getTrades();
            BWGVillagerTrades.TRADES.get(event.getType()).forEach(pair -> ((List)trades.get(((Integer)pair.getFirst()).intValue())).add((trader, random) -> (MerchantOffer)pair.getSecond()));
        }
    }

    private static void onBoneMealUse(BonemealEvent event) {
        if (event.getLevel().m_5776_()) {
            return;
        }
        ServerLevel level = (ServerLevel)event.getLevel();
        BlockPos pos = event.getPos();
        if (event.getBlock().m_60713_(Blocks.f_50440_)) {
            if (level.m_204166_(pos).m_203565_(BWGBiomes.PRAIRIE)) {
                BoneMealHandler.grassBoneMealHandler(level, pos.m_7494_(), (Block)BWGBlocks.PRAIRIE_GRASS.get(), BWGOverworldVegationPlacedFeatures.PRAIRIE_GRASS_BONEMEAL, false);
                event.setResult(Event.Result.ALLOW);
            } else if (level.m_204166_(pos).m_203565_(BWGBiomes.ALLIUM_SHRUBLAND)) {
                BoneMealHandler.grassBoneMealHandler(level, pos.m_7494_(), Blocks.f_50034_, (ResourceKey<PlacedFeature>)VegetationPlacements.f_195459_, true);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }
}

