/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.block;

import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModParticleTypes;

public class ScrapBinBlock
extends Block
implements WorldlyContainerHolder {
    public static final int READY = 8;
    public static final int MIN_LEVEL = 0;
    public static final int MAX_LEVEL = 7;
    public static final IntegerProperty LEVEL = BlockStateProperties.f_61419_;
    public static final Object2FloatMap<ItemLike> SCRAPABLE = new Object2FloatOpenHashMap();
    private static final int AABB_SIDE_THICKNESS = 2;
    private static final VoxelShape OUTER_SHAPE = Shapes.m_83144_();
    private static final VoxelShape[] SHAPES = (VoxelShape[])Util.m_137469_((Object)new VoxelShape[9], p_51967_ -> {
        for (int i = 0; i < 8; ++i) {
            p_51967_[i] = Shapes.m_83113_((VoxelShape)OUTER_SHAPE, (VoxelShape)Block.m_49796_((double)2.0, (double)Math.max(2, 1 + i * 2), (double)2.0, (double)14.0, (double)16.0, (double)14.0), (BooleanOp)BooleanOp.f_82685_);
        }
        p_51967_[8] = p_51967_[7];
    });

    public static void bootStrap() {
        SCRAPABLE.defaultReturnValue(-1.0f);
        float f = 0.3f;
        float f1 = 0.5f;
        float f2 = 0.65f;
        float f3 = 0.85f;
        float f4 = 1.0f;
        ScrapBinBlock.add(0.1f, (ItemLike)Items.f_42749_);
        ScrapBinBlock.add(0.2f, (ItemLike)Items.f_42025_);
        ScrapBinBlock.add(0.2f, (ItemLike)Items.f_42026_);
        ScrapBinBlock.add(0.3f, (ItemLike)Items.f_42384_);
        ScrapBinBlock.add(0.3f, (ItemLike)Items.f_42151_);
        ScrapBinBlock.add(0.4f, (ItemLike)Items.f_42446_);
        ScrapBinBlock.add(0.4f, (ItemLike)Items.f_42387_);
        ScrapBinBlock.add(0.4f, (ItemLike)Items.f_42383_);
        ScrapBinBlock.add(0.4f, (ItemLike)Items.f_42385_);
        ScrapBinBlock.add(0.4f, (ItemLike)Items.f_42386_);
        ScrapBinBlock.add(0.5f, (ItemLike)Items.f_42128_);
        ScrapBinBlock.add(0.5f, (ItemLike)Items.f_42471_);
        ScrapBinBlock.add(0.5f, (ItemLike)Items.f_42416_);
        ScrapBinBlock.add(0.6f, (ItemLike)Items.f_42468_);
        ScrapBinBlock.add(0.6f, (ItemLike)Items.f_42155_);
        ScrapBinBlock.add(0.7f, (ItemLike)Items.f_42470_);
        ScrapBinBlock.add(1.0f, (ItemLike)Items.f_42469_);
        ScrapBinBlock.add(1.0f, (ItemLike)Items.f_42651_);
        ScrapBinBlock.add(1.0f, (ItemLike)Items.f_42341_);
        ScrapBinBlock.add(1.0f, (ItemLike)Items.f_41913_);
        ScrapBinBlock.add(1.0f, (ItemLike)Items.f_42449_);
    }

    private static void add(float pChance, ItemLike pItem) {
        SCRAPABLE.put((Object)pItem.m_5456_(), pChance);
    }

    public ScrapBinBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public static void handleFill(Level pLevel, BlockPos pPos, boolean pSuccess) {
        BlockState blockstate = pLevel.m_8055_(pPos);
        pLevel.m_245747_(pPos, pSuccess ? SoundEvents.f_11765_ : SoundEvents.f_11764_, SoundSource.BLOCKS, 1.0f, 1.0f, false);
        double d0 = blockstate.m_60808_((BlockGetter)pLevel, pPos).m_83290_(Direction.Axis.Y, 0.5, 0.5) + 0.03125;
        double d1 = 0.13125f;
        double d2 = 0.7375f;
        RandomSource randomsource = pLevel.m_213780_();
        for (int i = 0; i < 10; ++i) {
            double d3 = randomsource.m_188583_() * 0.02;
            double d4 = randomsource.m_188583_() * 0.02;
            double d5 = randomsource.m_188583_() * 0.02;
            pLevel.m_7106_((ParticleOptions)ModParticleTypes.SCRAP.get(), (double)pPos.m_123341_() + (double)0.13125f + (double)0.7375f * (double)randomsource.m_188501_(), (double)pPos.m_123342_() + d0 + (double)randomsource.m_188501_() * (1.0 - d0), (double)pPos.m_123343_() + (double)0.13125f + (double)0.7375f * (double)randomsource.m_188501_(), d3, d4, d5);
        }
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES[(Integer)pState.m_61143_((Property)LEVEL)];
    }

    public VoxelShape m_6079_(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return OUTER_SHAPE;
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES[0];
    }

    public void m_6807_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if ((Integer)pState.m_61143_((Property)LEVEL) == 7) {
            pLevel.m_186460_(pPos, pState.m_60734_(), 20);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        int i = (Integer)pState.m_61143_((Property)LEVEL);
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (i < 8 && SCRAPABLE.containsKey((Object)itemstack.m_41720_())) {
            if (i < 7 && !pLevel.f_46443_) {
                BlockState blockstate = ScrapBinBlock.addItem((Entity)pPlayer, pState, (LevelAccessor)pLevel, pPos, itemstack);
                pLevel.m_46796_(1500, pPos, pState != blockstate ? 1 : 0);
                pPlayer.m_36246_(Stats.f_12982_.m_12902_((Object)itemstack.m_41720_()));
                if (!pPlayer.m_150110_().f_35937_) {
                    itemstack.m_41774_(1);
                }
            }
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        if (i == 8) {
            ScrapBinBlock.extractProduce((Entity)pPlayer, pState, pLevel, pPos);
            return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static BlockState insertItem(Entity pEntity, BlockState pState, ServerLevel pLevel, ItemStack pStack, BlockPos pPos) {
        int i = (Integer)pState.m_61143_((Property)LEVEL);
        if (i < 7 && SCRAPABLE.containsKey((Object)pStack.m_41720_())) {
            BlockState blockstate = ScrapBinBlock.addItem(pEntity, pState, (LevelAccessor)pLevel, pPos, pStack);
            pStack.m_41774_(1);
            return blockstate;
        }
        return pState;
    }

    public static BlockState extractProduce(Entity pEntity, BlockState pState, Level pLevel, BlockPos pPos) {
        if (!pLevel.f_46443_) {
            Vec3 vec3 = Vec3.m_272021_((Vec3i)pPos, (double)0.5, (double)1.01, (double)0.5).m_272010_(pLevel.f_46441_, 0.7f);
            for (int i = 0; i < 8; ++i) {
                ItemEntity itementity = new ItemEntity(pLevel, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), new ItemStack((ItemLike)ModItems.SCRAP.get()));
                pLevel.m_7967_((Entity)itementity);
            }
            int random = new Random().nextInt(1) + 2;
            for (int i = 0; i < random; ++i) {
                ItemEntity itementity = new ItemEntity(pLevel, vec3.m_7096_(), vec3.m_7098_(), vec3.m_7094_(), new ItemStack((ItemLike)ModItems.TECH_TRASH.get()));
                pLevel.m_7967_((Entity)itementity);
            }
        }
        BlockState blockstate = ScrapBinBlock.empty(pEntity, pState, (LevelAccessor)pLevel, pPos);
        pLevel.m_5594_((Player)null, pPos, SoundEvents.f_11763_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return blockstate;
    }

    static BlockState empty(@Nullable Entity pEntity, BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        BlockState blockstate = (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0));
        pLevel.m_7731_(pPos, blockstate, 3);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)blockstate));
        return blockstate;
    }

    static BlockState addItem(@Nullable Entity pEntity, BlockState pState, LevelAccessor pLevel, BlockPos pPos, ItemStack pStack) {
        int i = (Integer)pState.m_61143_((Property)LEVEL);
        float f = SCRAPABLE.getFloat((Object)pStack.m_41720_());
        if (!(i == 0 && f > 0.0f || pLevel.m_213780_().m_188500_() < (double)f)) {
            return pState;
        }
        int j = i + 1;
        BlockState blockstate = (BlockState)pState.m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(j));
        pLevel.m_7731_(pPos, blockstate, 3);
        pLevel.m_220407_(GameEvent.f_157792_, pPos, GameEvent.Context.m_223719_((Entity)pEntity, (BlockState)blockstate));
        if (j == 7) {
            pLevel.m_186460_(pPos, pState.m_60734_(), 20);
        }
        return blockstate;
    }

    public void m_213897_(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if ((Integer)pState.m_61143_((Property)LEVEL) == 7) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61122_((Property)LEVEL), 3);
            pLevel.m_5594_((Player)null, pPos, SoundEvents.f_11766_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
    }

    public boolean m_7278_(BlockState pState) {
        return true;
    }

    public int m_6782_(BlockState pBlockState, Level pLevel, BlockPos pPos) {
        return (Integer)pBlockState.m_61143_((Property)LEVEL);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{LEVEL});
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }

    public WorldlyContainer m_5840_(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
        int i = (Integer)pState.m_61143_((Property)LEVEL);
        if (i == 8) {
            return new OutputContainer(pState, pLevel, pPos, new ItemStack((ItemLike)Items.f_42499_));
        }
        return (WorldlyContainer)(i < 7 ? new InputContainer(pState, pLevel, pPos) : new EmptyContainer());
    }

    static class OutputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public OutputContainer(BlockState pState, LevelAccessor pLevel, BlockPos pPos, ItemStack pStack) {
            super(new ItemStack[]{pStack});
            this.state = pState;
            this.level = pLevel;
            this.pos = pPos;
        }

        public int m_6893_() {
            return 1;
        }

        public int[] m_7071_(Direction pSide) {
            int[] nArray;
            if (pSide == Direction.DOWN) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
            return false;
        }

        public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
            return !this.changed && pDirection == Direction.DOWN && pStack.m_150930_(Items.f_42499_);
        }

        public void m_6596_() {
            ScrapBinBlock.empty(null, this.state, this.level, this.pos);
            this.changed = true;
        }
    }

    static class InputContainer
    extends SimpleContainer
    implements WorldlyContainer {
        private final BlockState state;
        private final LevelAccessor level;
        private final BlockPos pos;
        private boolean changed;

        public InputContainer(BlockState pState, LevelAccessor pLevel, BlockPos pPos) {
            super(1);
            this.state = pState;
            this.level = pLevel;
            this.pos = pPos;
        }

        public int m_6893_() {
            return 1;
        }

        public int[] m_7071_(Direction pSide) {
            int[] nArray;
            if (pSide == Direction.UP) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = new int[]{};
            }
            return nArray;
        }

        public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
            return !this.changed && pDirection == Direction.UP && SCRAPABLE.containsKey((Object)pItemStack.m_41720_());
        }

        public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
            return false;
        }

        public void m_6596_() {
            ItemStack itemstack = this.m_8020_(0);
            if (!itemstack.m_41619_()) {
                this.changed = true;
                BlockState blockstate = ScrapBinBlock.addItem(null, this.state, this.level, this.pos, itemstack);
                this.level.m_46796_(1500, this.pos, blockstate != this.state ? 1 : 0);
                this.m_8016_(0);
            }
        }
    }

    static class EmptyContainer
    extends SimpleContainer
    implements WorldlyContainer {
        public EmptyContainer() {
            super(0);
        }

        public int[] m_7071_(Direction pSide) {
            return new int[0];
        }

        public boolean m_7155_(int pIndex, ItemStack pItemStack, @Nullable Direction pDirection) {
            return false;
        }

        public boolean m_7157_(int pIndex, ItemStack pStack, Direction pDirection) {
            return false;
        }
    }
}

