/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.handler;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemCooldowns;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.handler.AimingHandler;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.event.GunFireEvent;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.util.GunModifierHelper;

public class GunRecoilHandler {
    private static GunRecoilHandler instance;
    private final Random random = new Random();
    private double gunRecoilNormal;
    private double gunRecoilAngle;
    private float gunRecoilRandom;
    private float cameraRecoil;
    private float progressCameraRecoil;
    private static int recoilRand;

    public static GunRecoilHandler get() {
        if (instance == null) {
            instance = new GunRecoilHandler();
        }
        return instance;
    }

    private GunRecoilHandler() {
    }

    @SubscribeEvent
    public void preShoot(GunFireEvent.Pre event) {
        if (!event.isClient()) {
            return;
        }
        if (!((Boolean)Config.SERVER.enableCameraRecoil.get()).booleanValue()) {
            return;
        }
        recoilRand = new Random().nextInt(2);
    }

    @SubscribeEvent
    public void onGunFire(GunFireEvent.Post event) {
        if (!event.isClient()) {
            return;
        }
        if (!((Boolean)Config.SERVER.enableCameraRecoil.get()).booleanValue()) {
            return;
        }
        ItemStack heldItem = event.getStack();
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        float recoilModifier = 1.0f - GunModifierHelper.getRecoilModifier(heldItem);
        recoilModifier = (float)((double)recoilModifier * this.getAdsRecoilReduction(modifiedGun));
        this.cameraRecoil = modifiedGun.getGeneral().getRecoilAngle() * recoilModifier;
        this.progressCameraRecoil = 0.0f;
        this.gunRecoilRandom = this.random.nextFloat();
    }

    @SubscribeEvent
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase != TickEvent.Phase.END || this.cameraRecoil <= 0.0f) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        if (!((Boolean)Config.SERVER.enableCameraRecoil.get()).booleanValue()) {
            return;
        }
        float recoilAmount = this.cameraRecoil * mc.m_91297_() * 0.15f;
        float startProgress = this.progressCameraRecoil / this.cameraRecoil;
        float endProgress = (this.progressCameraRecoil + recoilAmount) / this.cameraRecoil;
        float pitch = mc.f_91074_.m_146909_();
        float yaw = mc.f_91074_.m_146908_();
        if (startProgress < 0.2f) {
            mc.f_91074_.m_146926_(pitch - (endProgress - startProgress) / 0.2f * this.cameraRecoil);
            if (recoilRand == 1) {
                mc.f_91074_.m_146922_(yaw - (endProgress - startProgress) / 0.2f * this.cameraRecoil / 2.0f);
            } else {
                mc.f_91074_.m_146922_(yaw + (endProgress - startProgress) / 0.2f * this.cameraRecoil / 2.0f);
            }
        } else {
            mc.f_91074_.m_146926_(pitch + (endProgress - startProgress) / 0.8f * this.cameraRecoil);
            if (recoilRand == 1) {
                mc.f_91074_.m_146922_(yaw + (endProgress - startProgress) / 0.8f * this.cameraRecoil / 2.0f);
            } else {
                mc.f_91074_.m_146922_(yaw - (endProgress - startProgress) / 0.8f * this.cameraRecoil / 2.0f);
            }
        }
        this.progressCameraRecoil += recoilAmount;
        if (this.progressCameraRecoil >= this.cameraRecoil) {
            this.cameraRecoil = 0.0f;
            this.progressCameraRecoil = 0.0f;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRenderOverlay(RenderHandEvent event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack heldItem = event.getItemStack();
        if (!(heldItem.m_41720_() instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)heldItem.m_41720_();
        Gun modifiedGun = gunItem.getModifiedGun(heldItem);
        ItemCooldowns tracker = Minecraft.m_91087_().f_91074_.m_36335_();
        float cooldown = tracker.m_41521_((Item)gunItem, Minecraft.m_91087_().m_91296_());
        float f = cooldown = cooldown >= modifiedGun.getGeneral().getRecoilDurationOffset() ? (cooldown - modifiedGun.getGeneral().getRecoilDurationOffset()) / (1.0f - modifiedGun.getGeneral().getRecoilDurationOffset()) : 0.0f;
        if ((double)cooldown >= 0.8) {
            float amount = 1.0f * ((1.0f - cooldown) / 0.2f);
            this.gunRecoilNormal = 1.0f - (amount -= 1.0f) * amount * amount * amount;
        } else {
            float amount = cooldown / 0.8f;
            this.gunRecoilNormal = (double)amount < 0.5 ? (double)(2.0f * amount * amount) : (double)(-1.0f + (4.0f - 2.0f * amount) * amount);
        }
        this.gunRecoilAngle = modifiedGun.getGeneral().getRecoilAngle();
    }

    public double getAdsRecoilReduction(Gun gun) {
        return 1.0 - (double)gun.getGeneral().getRecoilAdsReduction() * AimingHandler.get().getNormalisedAdsProgress();
    }

    public double getGunRecoilNormal() {
        return this.gunRecoilNormal;
    }

    public double getGunRecoilAngle() {
        return this.gunRecoilAngle;
    }

    public float getGunRecoilRandom() {
        return this.gunRecoilRandom;
    }
}

