/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.medal;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import ttv.migami.jeg.client.medal.Medal;
import ttv.migami.jeg.client.medal.MedalType;
import ttv.migami.jeg.client.util.FPSUtil;
import ttv.migami.jeg.init.ModSounds;

public class MedalManager {
    private static final ResourceLocation HEADSHOT = new ResourceLocation("jeg", "textures/gui/medal/combat_headshot.png");
    private static final ResourceLocation DOUBLE_KILL = new ResourceLocation("jeg", "textures/gui/medal/multikill_kill_double.png");
    private static final ResourceLocation TRIPLE_KILL = new ResourceLocation("jeg", "textures/gui/medal/multikill_kill_triple.png");
    private static final ResourceLocation QUAD_KILL = new ResourceLocation("jeg", "textures/gui/medal/multikill_kill_quad.png");
    private static final ResourceLocation PENTA_KILL = new ResourceLocation("jeg", "textures/gui/medal/multikill_kill_penta.png");
    private static final ResourceLocation KILLING_SPREE = new ResourceLocation("jeg", "textures/gui/medal/multikill_killing_spree.png");
    private static final List<Medal> MEDALS = new ArrayList<Medal>();
    private static final Queue<Medal> PENDING_MEDALS = new LinkedList<Medal>();
    private static Medal currentPlayingMedal = null;
    private static long lastKillTime = 0L;
    private static int multiKillCount = 0;
    private static boolean isHeadshot = false;

    private static Medal newMedal(ResourceLocation texture, MutableComponent description, SoundEvent soundEvent) {
        int screenWidth = Minecraft.m_91087_().m_91268_().m_85445_();
        return new Medal(texture, screenWidth / 2 - 32, 20, 60.0 * FPSUtil.calc(), description, soundEvent);
    }

    public static void addEnumMedal(int id) {
        if (MedalManager.getMedalByPosition(id) == null) {
            return;
        }
        String medalType = MedalManager.getMedalByPosition(id).toString().toLowerCase();
        ResourceLocation texture = new ResourceLocation("jeg", "textures/gui/medal/" + medalType + ".png");
        MutableComponent description = Component.m_237115_((String)("medal.jeg." + medalType));
        SoundEvent soundEvent = (SoundEvent)ModSounds.MEDAL_GENERIC.get();
        Medal medal = MedalManager.newMedal(texture, description, soundEvent);
        if (currentPlayingMedal == null) {
            currentPlayingMedal = medal;
            MedalManager.playMedalSound(soundEvent);
            MEDALS.add(medal);
        } else {
            PENDING_MEDALS.add(medal);
        }
    }

    public static MedalType getMedalByPosition(int position) {
        if (position < 0 || position >= MedalType.values().length) {
            return null;
        }
        return MedalType.values()[position];
    }

    public void addMedal(ResourceLocation texture, MutableComponent description, SoundEvent soundEvent) {
        Medal medal = MedalManager.newMedal(texture, description, soundEvent);
        if (currentPlayingMedal == null) {
            currentPlayingMedal = medal;
            MedalManager.playMedalSound(soundEvent);
            MEDALS.add(medal);
        } else {
            PENDING_MEDALS.add(medal);
        }
    }

    public static void addKillMedal(ResourceLocation texture, MutableComponent description) {
        long currentTime = System.currentTimeMillis();
        multiKillCount = currentTime - lastKillTime <= 2000L ? ++multiKillCount : 1;
        lastKillTime = currentTime;
        if (isHeadshot) {
            ResourceLocation headshotTexture = HEADSHOT;
            MutableComponent headshotDescription = Component.m_237115_((String)"medal.jeg.combat_headshot");
            SoundEvent headshotSound = (SoundEvent)ModSounds.MEDAL_HEADSHOT.get();
            Medal headshotMedal = MedalManager.newMedal(headshotTexture, headshotDescription, headshotSound);
            if (currentPlayingMedal == null) {
                currentPlayingMedal = headshotMedal;
                MedalManager.playMedalSound(headshotSound);
                MEDALS.add(headshotMedal);
            } else {
                PENDING_MEDALS.add(headshotMedal);
            }
            isHeadshot = false;
        }
        ResourceLocation medalTexture = MedalManager.getMedalTexture(texture);
        description = MedalManager.getMedalText(description);
        SoundEvent sound = (SoundEvent)ModSounds.MEDAL_GENERIC.get();
        Medal medal = MedalManager.newMedal(medalTexture, description, sound);
        if (currentPlayingMedal == null) {
            currentPlayingMedal = medal;
            MedalManager.playMedalSound(sound);
            MEDALS.add(medal);
        } else {
            PENDING_MEDALS.add(medal);
        }
    }

    public static void setHeadshot(boolean headshot) {
        isHeadshot = headshot;
    }

    private static ResourceLocation getMedalTexture(ResourceLocation texture) {
        ResourceLocation medalTexture = texture;
        if (multiKillCount == 2) {
            medalTexture = DOUBLE_KILL;
        } else if (multiKillCount == 3) {
            medalTexture = TRIPLE_KILL;
        } else if (multiKillCount == 4) {
            medalTexture = QUAD_KILL;
        } else if (multiKillCount == 5) {
            medalTexture = PENTA_KILL;
        } else if (multiKillCount > 5) {
            medalTexture = KILLING_SPREE;
        }
        return medalTexture;
    }

    private static MutableComponent getMedalText(MutableComponent description) {
        if (multiKillCount == 2) {
            description = Component.m_237115_((String)"medal.jeg.multikill_double_kill");
        } else if (multiKillCount == 3) {
            description = Component.m_237115_((String)"medal.jeg.multikill_triple_kill");
        } else if (multiKillCount == 4) {
            description = Component.m_237115_((String)"medal.jeg.multikill_quad_kill");
        } else if (multiKillCount == 5) {
            description = Component.m_237115_((String)"medal.jeg.multikill_penta_kill");
        } else if (multiKillCount > 5) {
            description = Component.m_237115_((String)"medal.jeg.multikill_killing_spree");
        }
        return description;
    }

    private static void playMedalSound(SoundEvent sound) {
        if (sound != null) {
            Minecraft.m_91087_().f_91074_.m_5496_(sound, 1.0f, 1.0f);
        }
    }

    public static void render(GuiGraphics guiGraphics) {
        if (currentPlayingMedal != null && currentPlayingMedal.getLifetime() <= 30.0 * FPSUtil.calc() && !PENDING_MEDALS.isEmpty()) {
            currentPlayingMedal = PENDING_MEDALS.poll();
            MedalManager.playMedalSound(currentPlayingMedal.getSound());
            MEDALS.add(currentPlayingMedal);
        }
        MEDALS.removeIf(Medal::tick);
        if (MEDALS.isEmpty()) {
            currentPlayingMedal = null;
        }
        for (Medal medal : MEDALS) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)medal.getOpacity());
            guiGraphics.m_280163_(medal.getTexture(), medal.getX(), medal.getY(), 0.0f, 0.0f, 64, 64, 64, 64);
            String description = medal.getDescription().getString();
            int textWidth = Minecraft.m_91087_().f_91062_.m_92895_(description);
            int textX = medal.getX() + (64 - textWidth) / 2;
            guiGraphics.m_280488_(Minecraft.m_91087_().f_91062_, description, textX, medal.getY() + 70, 0xFFFFFF);
            RenderSystem.disableBlend();
            guiGraphics.m_280168_().m_85849_();
        }
    }
}

