/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.client.render;

import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.client.medal.MedalManager;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.util.GunModifierHelper;

@Mod.EventBusSubscriber(modid="jeg", value={Dist.CLIENT})
public class GuiRenderer {
    @SubscribeEvent
    public static void onRenderGameOverlay(RenderGuiOverlayEvent.Post event) {
        Minecraft minecraft = Minecraft.m_91087_();
        LocalPlayer player = minecraft.f_91074_;
        if (player == null) {
            return;
        }
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            Item item;
            MedalManager.render(event.getGuiGraphics());
            ItemStack heldItem = player.m_21205_();
            if (!heldItem.m_41619_() && (item = heldItem.m_41720_()) instanceof GunItem) {
                int maxAmmo;
                GunItem gunItem = (GunItem)item;
                if (!((Boolean)Config.CLIENT.display.showAmmoGUI.get()).booleanValue()) {
                    return;
                }
                CompoundTag tag = heldItem.m_41783_();
                if (tag == null || !tag.m_128441_("AmmoCount")) {
                    return;
                }
                int ammoCount = tag.m_128451_("AmmoCount");
                GuiGraphics guiGraphics = event.getGuiGraphics();
                ResourceLocation texture = new ResourceLocation("jeg", "textures/gui/ammo/bullet.png");
                int segmentWidth = 3;
                int segmentHeight = 9;
                int rowPadding = 0;
                int rowHeight = segmentHeight + rowPadding;
                int segmentsPerRow = 30;
                int textureRows = 4;
                if (GunModifierHelper.getModifiedAmmoCapacity(heldItem, gunItem.getGun()) <= 12) {
                    texture = new ResourceLocation("jeg", "textures/gui/ammo/shell.png");
                    segmentWidth = 15;
                    segmentsPerRow = 6;
                }
                if (ammoCount > (maxAmmo = segmentsPerRow * textureRows)) {
                    ammoCount = maxAmmo;
                }
                int startX = (int)((double)minecraft.m_91268_().m_85445_() * 0.95 - 90.0) + (Integer)Config.CLIENT.display.displayAmmoGUIXOffset.get();
                int startY = minecraft.m_91268_().m_85446_() - 45 + (Integer)Config.CLIENT.display.displayAmmoGUIYOffset.get();
                MutableComponent name = Component.m_237115_((String)heldItem.m_41778_()).m_130940_(ChatFormatting.WHITE);
                int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)name);
                guiGraphics.m_280614_(Minecraft.m_91087_().f_91062_, (Component)name, startX, startY - 9, 0xFFFFFF, true);
                int fullRows = ammoCount / segmentsPerRow;
                int extraSegments = ammoCount % segmentsPerRow;
                for (int row = 0; row < fullRows; ++row) {
                    int renderWidth = segmentsPerRow * segmentWidth;
                    int renderHeight = segmentHeight;
                    int textureY = row * rowHeight;
                    guiGraphics.m_280163_(texture, startX, startY + row * rowHeight, 0.0f, (float)textureY, renderWidth, renderHeight, 90, 9);
                }
                if (extraSegments > 0) {
                    int renderWidth = extraSegments * segmentWidth;
                    int renderHeight = segmentHeight;
                    int textureY = fullRows * rowHeight;
                    guiGraphics.m_280163_(texture, startX, startY + fullRows * rowHeight, 0.0f, (float)textureY, renderWidth, renderHeight, 90, 9);
                }
            }
        }
    }
}

