/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.common;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import ttv.migami.jeg.JustEnoughGuns;
import ttv.migami.jeg.annotation.Ignored;
import ttv.migami.jeg.annotation.Optional;
import ttv.migami.jeg.client.ClientHandler;
import ttv.migami.jeg.common.AmmoContext;
import ttv.migami.jeg.common.FireMode;
import ttv.migami.jeg.common.GripType;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.debug.Debug;
import ttv.migami.jeg.debug.IDebugWidget;
import ttv.migami.jeg.debug.IEditorMenu;
import ttv.migami.jeg.debug.client.screen.widget.DebugButton;
import ttv.migami.jeg.debug.client.screen.widget.DebugSlider;
import ttv.migami.jeg.debug.client.screen.widget.DebugToggle;
import ttv.migami.jeg.init.ModEnchantments;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.item.ScopeItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.item.attachment.impl.Scope;
import ttv.migami.jeg.util.GunJsonUtil;
import ttv.migami.jeg.util.SuperBuilder;

public class Gun
implements INBTSerializable<CompoundTag>,
IEditorMenu {
    protected General general = new General();
    protected Reloads reloads = new Reloads();
    protected Projectile projectile = new Projectile();
    protected Sounds sounds = new Sounds();
    protected Display display = new Display();
    protected Modules modules = new Modules();

    public General getGeneral() {
        return this.general;
    }

    public Reloads getReloads() {
        return this.reloads;
    }

    public Projectile getProjectile() {
        return this.projectile;
    }

    public Sounds getSounds() {
        return this.sounds;
    }

    public Display getDisplay() {
        return this.display;
    }

    public Modules getModules() {
        return this.modules;
    }

    @Override
    public Component getEditorLabel() {
        return Component.m_237115_((String)"Gun");
    }

    @Override
    public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            ItemStack heldItem = Objects.requireNonNull(Minecraft.m_91087_().f_91074_).m_21205_();
            ItemStack scope = Gun.getScopeStack(heldItem);
            Item patt2973$temp = scope.m_41720_();
            if (patt2973$temp instanceof ScopeItem) {
                ScopeItem scopeItem = (ScopeItem)patt2973$temp;
                widgets.add(Pair.of((Object)scope.m_41720_().m_7626_(scope), () -> new DebugButton((Component)Component.m_237115_((String)"Edit"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(Debug.getScope(scopeItem))))));
            }
            widgets.add(Pair.of((Object)this.modules.getEditorLabel(), () -> new DebugButton((Component)Component.m_237115_((String)">"), btn -> Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.modules)))));
        });
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("General", (Tag)this.general.serializeNBT());
        tag.m_128365_("Reloads", (Tag)this.reloads.serializeNBT());
        tag.m_128365_("Projectile", (Tag)this.projectile.serializeNBT());
        tag.m_128365_("Sounds", (Tag)this.sounds.serializeNBT());
        tag.m_128365_("Display", (Tag)this.display.serializeNBT());
        tag.m_128365_("Modules", (Tag)this.modules.serializeNBT());
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        if (tag.m_128425_("General", 10)) {
            this.general.deserializeNBT(tag.m_128469_("General"));
        }
        if (tag.m_128425_("Reloads", 10)) {
            this.reloads.deserializeNBT(tag.m_128469_("Reloads"));
        }
        if (tag.m_128425_("Projectile", 10)) {
            this.projectile.deserializeNBT(tag.m_128469_("Projectile"));
        }
        if (tag.m_128425_("Sounds", 10)) {
            this.sounds.deserializeNBT(tag.m_128469_("Sounds"));
        }
        if (tag.m_128425_("Display", 10)) {
            this.display.deserializeNBT(tag.m_128469_("Display"));
        }
        if (tag.m_128425_("Modules", 10)) {
            this.modules.deserializeNBT(tag.m_128469_("Modules"));
        }
    }

    public JsonObject toJsonObject() {
        JsonObject object = new JsonObject();
        object.add("general", (JsonElement)this.general.toJsonObject());
        object.add("reloads", (JsonElement)this.reloads.toJsonObject());
        object.add("projectile", (JsonElement)this.projectile.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "sounds", this.sounds.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "display", this.display.toJsonObject());
        GunJsonUtil.addObjectIfNotEmpty(object, "modules", this.modules.toJsonObject());
        return object;
    }

    public static Gun create(CompoundTag tag) {
        Gun gun = new Gun();
        gun.deserializeNBT(tag);
        return gun;
    }

    public Gun copy() {
        Gun gun = new Gun();
        gun.general = this.general.copy();
        gun.reloads = this.reloads.copy();
        gun.projectile = this.projectile.copy();
        gun.sounds = this.sounds.copy();
        gun.display = this.display.copy();
        gun.modules = this.modules.copy();
        return gun;
    }

    public boolean canAttachType(@Nullable IAttachment.Type type) {
        if (this.modules.attachments != null && type != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope != null;
                }
                case BARREL: {
                    return this.modules.attachments.barrel != null;
                }
                case STOCK: {
                    return this.modules.attachments.stock != null;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel != null;
                }
                case MAGAZINE: {
                    return this.modules.attachments.magazine != null;
                }
                case SIDE: {
                    return this.modules.attachments.side != null;
                }
            }
        }
        return false;
    }

    @Nullable
    public ScaledPositioned getAttachmentPosition(IAttachment.Type type) {
        if (this.modules.attachments != null) {
            switch (type) {
                case SCOPE: {
                    return this.modules.attachments.scope;
                }
                case BARREL: {
                    return this.modules.attachments.barrel;
                }
                case STOCK: {
                    return this.modules.attachments.stock;
                }
                case UNDER_BARREL: {
                    return this.modules.attachments.underBarrel;
                }
                case MAGAZINE: {
                    return this.modules.attachments.magazine;
                }
                case SIDE: {
                    return this.modules.attachments.side;
                }
            }
        }
        return null;
    }

    public boolean canAimDownSight() {
        return this.canAttachType(IAttachment.Type.SCOPE) || this.modules.zoom != null;
    }

    public static ItemStack getScopeStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Scope", 10)) {
            return ItemStack.m_41712_((CompoundTag)attachment.m_128469_("Scope"));
        }
        return ItemStack.f_41583_;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, Gun gun, IAttachment.Type type) {
        if (!gun.canAttachType(type)) {
            return false;
        }
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10)) {
            CompoundTag attachment = compound.m_128469_("Attachments");
            return attachment.m_128425_(type.getTagKey(), 10);
        }
        return false;
    }

    public static boolean hasAttachmentEquipped(ItemStack stack, IAttachment.Type type) {
        CompoundTag compound = stack.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10)) {
            CompoundTag attachment = compound.m_128469_("Attachments");
            return attachment.m_128425_(type.getTagKey(), 10);
        }
        return false;
    }

    @Nullable
    public static Scope getScope(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Scope", 10)) {
            ItemStack scopeStack = ItemStack.m_41712_((CompoundTag)attachment.m_128469_("Scope"));
            Scope scope = null;
            Item item = scopeStack.m_41720_();
            if (item instanceof ScopeItem) {
                ScopeItem scopeItem = (ScopeItem)item;
                if (JustEnoughGuns.isDebugging()) {
                    return Debug.getScope(scopeItem);
                }
                scope = scopeItem.getProperties();
            }
            return scope;
        }
        return null;
    }

    public static ItemStack getAttachment(IAttachment.Type type, ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_(type.getTagKey(), 10)) {
            return ItemStack.m_41712_((CompoundTag)attachment.m_128469_(type.getTagKey()));
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeAttachment(ItemStack gun, String attachmentStack) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_(attachmentStack, 10)) {
            attachment.m_128473_(attachmentStack);
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeScopeStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Scope", 10)) {
            attachment.m_128473_("Scope");
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeBarrelStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Barrel", 10)) {
            attachment.m_128473_("Barrel");
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeStockStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Stock", 10)) {
            attachment.m_128473_("Stock");
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeUnderBarrelStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Under_Barrel", 10)) {
            attachment.m_128473_("Under_Barrel");
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeMagazineStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Magazine", 10)) {
            attachment.m_128473_("Magazine");
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack removeSideStack(ItemStack gun) {
        CompoundTag attachment;
        CompoundTag compound = gun.m_41783_();
        if (compound != null && compound.m_128425_("Attachments", 10) && (attachment = compound.m_128469_("Attachments")).m_128425_("Side", 10)) {
            attachment.m_128473_("Side");
        }
        return ItemStack.f_41583_;
    }

    public static float getAdditionalDamage(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128457_("AdditionalDamage");
    }

    public static AmmoContext findAmmo(Player player, ResourceLocation id) {
        if (player.m_7500_() || player.m_21205_().getEnchantmentLevel((Enchantment)ModEnchantments.INFINITY.get()) != 0) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            ItemStack ammo = item != null ? new ItemStack((ItemLike)item, Integer.MAX_VALUE) : ItemStack.f_41583_;
            return new AmmoContext(ammo, null);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!Gun.isAmmo(stack, id)) continue;
            return new AmmoContext(stack, (Container)player.m_150109_());
        }
        return AmmoContext.NONE;
    }

    public static ItemStack[] findAmmoStack(Player player, ResourceLocation id) {
        if (!player.m_6084_()) {
            return new ItemStack[0];
        }
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (player.m_7500_() || player.m_21205_().getEnchantmentLevel((Enchantment)ModEnchantments.INFINITY.get()) != 0) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(id);
            stacks.add(item != null ? new ItemStack((ItemLike)item, Integer.MAX_VALUE) : ItemStack.f_41583_);
            return stacks.toArray(new ItemStack[0]);
        }
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (!Gun.isAmmo(stack, id)) continue;
            stacks.add(stack);
        }
        return stacks.toArray(new ItemStack[0]);
    }

    public static boolean isAmmo(ItemStack stack, ResourceLocation id) {
        return stack != null && Objects.equals(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()), id);
    }

    public static boolean hasAmmo(ItemStack gunStack) {
        CompoundTag tag = gunStack.m_41784_();
        return tag.m_128471_("IgnoreAmmo") || tag.m_128451_("AmmoCount") > 0;
    }

    public static float getFovModifier(ItemStack stack, Gun modifiedGun) {
        Scope scope;
        float modifier = 0.0f;
        if (Gun.hasAttachmentEquipped(stack, modifiedGun, IAttachment.Type.SCOPE) && (scope = Gun.getScope(stack)) != null && scope.getFovModifier() < 1.0f) {
            return Mth.m_14036_((float)scope.getFovModifier(), (float)0.01f, (float)1.0f);
        }
        Modules.Zoom zoom = modifiedGun.getModules().getZoom();
        return zoom != null ? modifier + zoom.getFovModifier() : 0.0f;
    }

    public static class General
    implements INBTSerializable<CompoundTag> {
        @Ignored
        private FireMode fireMode = FireMode.SEMI_AUTO;
        @Optional
        private int burstAmount;
        @Optional
        private int burstDelay;
        private int rate;
        @Optional
        private int fireTimer;
        private boolean silenced;
        private boolean customFiring;
        @Ignored
        private GripType gripType = GripType.ONE_HANDED;
        private float recoilAngle;
        @Optional
        private float recoilKick;
        @Optional
        private float recoilDurationOffset;
        @Optional
        private float recoilAdsReduction = 0.2f;
        @Optional
        private int projectileAmount = 1;
        @Optional
        private boolean alwaysSpread;
        @Optional
        private float spread;
        @Optional
        private boolean canBeBlueprinted = true;
        private boolean infinityDisabled;
        private boolean canFireUnderwater = false;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("FireMode", this.fireMode.getId().toString());
            tag.m_128405_("BurstAmount", this.burstAmount);
            tag.m_128405_("BurstDelay", this.burstDelay);
            tag.m_128405_("Rate", this.rate);
            tag.m_128405_("FireTimer", this.fireTimer);
            tag.m_128379_("Silenced", this.silenced);
            tag.m_128379_("CustomFiring", this.customFiring);
            tag.m_128359_("GripType", this.gripType.getId().toString());
            tag.m_128350_("RecoilAngle", this.recoilAngle);
            tag.m_128350_("RecoilKick", this.recoilKick);
            tag.m_128350_("RecoilDurationOffset", this.recoilDurationOffset);
            tag.m_128350_("RecoilAdsReduction", this.recoilAdsReduction);
            tag.m_128405_("ProjectileAmount", this.projectileAmount);
            tag.m_128379_("AlwaysSpread", this.alwaysSpread);
            tag.m_128350_("Spread", this.spread);
            tag.m_128379_("CanBeBlueprinted", this.canBeBlueprinted);
            tag.m_128379_("InfinityDisabled", this.infinityDisabled);
            tag.m_128379_("CanFireUnderwater", this.canFireUnderwater);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("FireMode", 8)) {
                this.fireMode = FireMode.getType(ResourceLocation.m_135820_((String)tag.m_128461_("FireMode")));
            }
            if (tag.m_128425_("BurstAmount", 99)) {
                this.burstAmount = tag.m_128451_("BurstAmount");
            }
            if (tag.m_128425_("BurstDelay", 99)) {
                this.burstDelay = tag.m_128451_("BurstDelay");
            }
            if (tag.m_128425_("Rate", 99)) {
                this.rate = tag.m_128451_("Rate");
            }
            if (tag.m_128425_("FireTimer", 99)) {
                this.fireTimer = tag.m_128451_("FireTimer");
            }
            if (tag.m_128425_("Silenced", 99)) {
                this.silenced = tag.m_128471_("Silenced");
            }
            if (tag.m_128425_("CustomFiring", 99)) {
                this.alwaysSpread = tag.m_128471_("CustomFiring");
            }
            if (tag.m_128425_("GripType", 8)) {
                this.gripType = GripType.getType(ResourceLocation.m_135820_((String)tag.m_128461_("GripType")));
            }
            if (tag.m_128425_("RecoilAngle", 99)) {
                this.recoilAngle = tag.m_128457_("RecoilAngle");
            }
            if (tag.m_128425_("RecoilKick", 99)) {
                this.recoilKick = tag.m_128457_("RecoilKick");
            }
            if (tag.m_128425_("RecoilDurationOffset", 99)) {
                this.recoilDurationOffset = tag.m_128457_("RecoilDurationOffset");
            }
            if (tag.m_128425_("RecoilAdsReduction", 99)) {
                this.recoilAdsReduction = tag.m_128457_("RecoilAdsReduction");
            }
            if (tag.m_128425_("ProjectileAmount", 99)) {
                this.projectileAmount = tag.m_128451_("ProjectileAmount");
            }
            if (tag.m_128425_("AlwaysSpread", 99)) {
                this.alwaysSpread = tag.m_128471_("AlwaysSpread");
            }
            if (tag.m_128425_("Spread", 99)) {
                this.spread = tag.m_128457_("Spread");
            }
            if (tag.m_128425_("CanBeBlueprinted", 99)) {
                this.canBeBlueprinted = tag.m_128471_("CanBeBlueprinted");
            }
            if (tag.m_128425_("InfinityDisabled", 99)) {
                this.infinityDisabled = tag.m_128471_("InfinityDisabled");
            }
            if (tag.m_128425_("CanFireUnderwater", 99)) {
                this.canFireUnderwater = tag.m_128471_("CanFireUnderwater");
            }
        }

        public JsonObject toJsonObject() {
            Preconditions.checkArgument((this.rate > 0 ? 1 : 0) != 0, (Object)"Rate must be more than zero");
            Preconditions.checkArgument((this.recoilAngle >= 0.0f ? 1 : 0) != 0, (Object)"Recoil angle must be more than or equal to zero");
            Preconditions.checkArgument((this.recoilKick >= 0.0f ? 1 : 0) != 0, (Object)"Recoil kick must be more than or equal to zero");
            Preconditions.checkArgument((this.recoilDurationOffset >= 0.0f && this.recoilDurationOffset <= 1.0f ? 1 : 0) != 0, (Object)"Recoil duration offset must be between 0.0 and 1.0");
            Preconditions.checkArgument((this.recoilAdsReduction >= 0.0f && this.recoilAdsReduction <= 1.0f ? 1 : 0) != 0, (Object)"Recoil ads reduction must be between 0.0 and 1.0");
            Preconditions.checkArgument((this.projectileAmount >= 1 ? 1 : 0) != 0, (Object)"Projectile amount must be more than or equal to one");
            Preconditions.checkArgument((this.spread >= 0.0f ? 1 : 0) != 0, (Object)"Spread must be more than or equal to zero");
            JsonObject object = new JsonObject();
            object.addProperty("fireMode", this.fireMode.getId().toString());
            if (this.burstAmount != 0) {
                object.addProperty("burstAmount", (Number)this.burstAmount);
            }
            if (this.burstAmount != 0 && this.burstDelay != 0) {
                object.addProperty("burstDelay", (Number)this.burstDelay);
            }
            object.addProperty("rate", (Number)this.rate);
            if (this.fireTimer != 0) {
                object.addProperty("fireTimer", (Number)this.fireTimer);
            }
            if (this.silenced) {
                object.addProperty("silenced", Boolean.valueOf(true));
            }
            if (this.customFiring) {
                object.addProperty("customFiring", Boolean.valueOf(true));
            }
            object.addProperty("gripType", this.gripType.getId().toString());
            if (this.recoilAngle != 0.0f) {
                object.addProperty("recoilAngle", (Number)Float.valueOf(this.recoilAngle));
            }
            if (this.recoilKick != 0.0f) {
                object.addProperty("recoilKick", (Number)Float.valueOf(this.recoilKick));
            }
            if (this.recoilDurationOffset != 0.0f) {
                object.addProperty("recoilDurationOffset", (Number)Float.valueOf(this.recoilDurationOffset));
            }
            if (this.recoilAdsReduction != 0.2f) {
                object.addProperty("recoilAdsReduction", (Number)Float.valueOf(this.recoilAdsReduction));
            }
            if (this.projectileAmount != 1) {
                object.addProperty("projectileAmount", (Number)this.projectileAmount);
            }
            if (this.alwaysSpread) {
                object.addProperty("alwaysSpread", Boolean.valueOf(true));
            }
            if (this.spread != 0.0f) {
                object.addProperty("spread", (Number)Float.valueOf(this.spread));
            }
            if (!this.canBeBlueprinted) {
                object.addProperty("canBeBlueprinted", Boolean.valueOf(this.canBeBlueprinted));
            }
            if (this.infinityDisabled) {
                object.addProperty("infinityDisabled", Boolean.valueOf(this.infinityDisabled));
            }
            if (this.canFireUnderwater) {
                object.addProperty("canFireUnderwater", Boolean.valueOf(this.canFireUnderwater));
            }
            return object;
        }

        public General copy() {
            General general = new General();
            general.fireMode = this.fireMode;
            general.burstAmount = this.burstAmount;
            general.burstDelay = this.burstDelay;
            general.rate = this.rate;
            general.fireTimer = this.fireTimer;
            general.silenced = this.silenced;
            general.customFiring = this.customFiring;
            general.gripType = this.gripType;
            general.recoilAngle = this.recoilAngle;
            general.recoilKick = this.recoilKick;
            general.recoilDurationOffset = this.recoilDurationOffset;
            general.recoilAdsReduction = this.recoilAdsReduction;
            general.projectileAmount = this.projectileAmount;
            general.alwaysSpread = this.alwaysSpread;
            general.spread = this.spread;
            general.canBeBlueprinted = this.canBeBlueprinted;
            general.infinityDisabled = this.infinityDisabled;
            general.canFireUnderwater = this.canFireUnderwater;
            return general;
        }

        public FireMode getFireMode() {
            return this.fireMode;
        }

        public int getBurstAmount() {
            return this.burstAmount;
        }

        public int getBurstDelay() {
            return this.burstDelay;
        }

        public int getRate() {
            return this.rate;
        }

        public int getFireTimer() {
            return this.fireTimer;
        }

        public boolean isSilenced() {
            return this.silenced;
        }

        public boolean isCustomFiring() {
            return this.customFiring;
        }

        public GripType getGripType() {
            return this.gripType;
        }

        public float getRecoilAngle() {
            return this.recoilAngle;
        }

        public float getRecoilKick() {
            return this.recoilKick;
        }

        public float getRecoilDurationOffset() {
            return this.recoilDurationOffset;
        }

        public float getRecoilAdsReduction() {
            return this.recoilAdsReduction;
        }

        public int getProjectileAmount() {
            return this.projectileAmount;
        }

        public boolean isAlwaysSpread() {
            return this.alwaysSpread;
        }

        public float getSpread() {
            return this.spread;
        }

        public boolean canBeBlueprinted() {
            return this.canBeBlueprinted;
        }

        public boolean isInfinityDisabled() {
            return this.infinityDisabled;
        }

        public boolean canFireUnderwater() {
            return this.canFireUnderwater;
        }
    }

    public static class Reloads
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Ignored
        private ResourceLocation reloadItem = new ResourceLocation("jeg", "scrap");
        private int maxAmmo = 30;
        @Ignored
        private ReloadType reloadType = ReloadType.MANUAL;
        private int reloadTimer = 20;
        private int emptyMagTimer = 5;
        private int reloadAmount = 1;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("ReloadItem", this.reloadItem.toString());
            tag.m_128405_("MaxAmmo", this.maxAmmo);
            tag.m_128359_("ReloadType", this.reloadType.getId().toString());
            tag.m_128405_("ReloadTimer", this.reloadTimer);
            tag.m_128405_("EmptyMagTimer", this.emptyMagTimer);
            tag.m_128405_("ReloadAmount", this.reloadAmount);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("ReloadItem", 8)) {
                this.reloadItem = new ResourceLocation(tag.m_128461_("ReloadItem"));
            }
            if (tag.m_128425_("MaxAmmo", 99)) {
                this.maxAmmo = tag.m_128451_("MaxAmmo");
            }
            if (tag.m_128425_("ReloadType", 8)) {
                this.reloadType = ReloadType.getType(ResourceLocation.m_135820_((String)tag.m_128461_("ReloadType")));
            }
            if (tag.m_128425_("ReloadTimer", 99)) {
                this.reloadTimer = tag.m_128451_("ReloadTimer");
            }
            if (tag.m_128425_("EmptyMagTimer", 99)) {
                this.emptyMagTimer = tag.m_128451_("EmptyMagTimer");
            }
            if (tag.m_128425_("ReloadAmount", 99)) {
                this.reloadAmount = tag.m_128451_("ReloadAmount");
            }
        }

        public JsonObject toJsonObject() {
            Preconditions.checkArgument((this.maxAmmo > 0 ? 1 : 0) != 0, (Object)"Max ammo must be more than zero");
            Preconditions.checkArgument((this.reloadTimer >= 0 ? 1 : 0) != 0, (Object)"Reload timer must be more than or equal to zero");
            Preconditions.checkArgument((this.emptyMagTimer >= 0 ? 1 : 0) != 0, (Object)"Empty mag additional reload timer must be more than or equal to zero");
            Preconditions.checkArgument((this.reloadAmount >= 1 ? 1 : 0) != 0, (Object)"Reloading amount must be more than or equal to zero");
            JsonObject object = new JsonObject();
            if (!this.reloadItem.toString().matches(ModItems.SCRAP.getId().toString())) {
                object.addProperty("reloadItem", this.reloadItem.toString());
            }
            object.addProperty("maxAmmo", (Number)this.maxAmmo);
            object.addProperty("reloadType", this.reloadType.getId().toString());
            object.addProperty("reloadTimer", (Number)this.reloadTimer);
            object.addProperty("emptyMagTimer", (Number)this.emptyMagTimer);
            if (this.reloadAmount != 1) {
                object.addProperty("reloadAmount", (Number)this.reloadAmount);
            }
            return object;
        }

        public Reloads copy() {
            Reloads reloads = new Reloads();
            reloads.reloadItem = this.reloadItem;
            reloads.maxAmmo = this.maxAmmo;
            reloads.reloadType = this.reloadType;
            reloads.reloadTimer = this.reloadTimer;
            reloads.emptyMagTimer = this.emptyMagTimer;
            reloads.reloadAmount = this.reloadAmount;
            return reloads;
        }

        public ResourceLocation getReloadItem() {
            return this.reloadItem;
        }

        public int getMaxAmmo() {
            return this.maxAmmo;
        }

        public ReloadType getReloadType() {
            return this.reloadType;
        }

        public int getReloadTimer() {
            return this.reloadTimer;
        }

        public int getEmptyMagTimer() {
            return this.emptyMagTimer;
        }

        public int getReloadAmount() {
            return this.reloadAmount;
        }
    }

    public static class Projectile
    implements INBTSerializable<CompoundTag> {
        private ResourceLocation item = new ResourceLocation("jeg", "pistol_ammo");
        @Optional
        private boolean ejectsCasing;
        @Optional
        private boolean visible;
        private boolean ignoresBlocks;
        private float damage;
        private float headshotMultiplier = 1.5f;
        @Optional
        private ResourceLocation advantage = new ResourceLocation("jeg", "none");
        private float size;
        private double speed;
        private int life;
        @Optional
        private boolean gravity;
        @Optional
        private boolean damageReduceOverLife;
        @Optional
        private int trailColor = 16765577;
        @Optional
        private double trailLengthMultiplier = 1.0;
        private boolean hideTrail;
        private boolean noProjectile;
        private boolean hitsRubberFruit;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("Item", this.item.toString());
            tag.m_128379_("EjectsCasing", this.ejectsCasing);
            tag.m_128379_("Visible", this.visible);
            tag.m_128379_("IgnoresBlocks", this.ignoresBlocks);
            tag.m_128350_("Damage", this.damage);
            tag.m_128350_("HeadshotMultiplier", this.headshotMultiplier);
            tag.m_128359_("Advantage", this.advantage.toString());
            tag.m_128350_("Size", this.size);
            tag.m_128347_("Speed", this.speed);
            tag.m_128405_("Life", this.life);
            tag.m_128379_("Gravity", this.gravity);
            tag.m_128379_("DamageReduceOverLife", this.damageReduceOverLife);
            tag.m_128405_("TrailColor", this.trailColor);
            tag.m_128347_("TrailLengthMultiplier", this.trailLengthMultiplier);
            tag.m_128379_("HideTrail", this.hideTrail);
            tag.m_128379_("NoProjectile", this.noProjectile);
            tag.m_128379_("HitsRubberFruit", this.hitsRubberFruit);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Item", 8)) {
                this.item = new ResourceLocation(tag.m_128461_("Item"));
            }
            if (tag.m_128425_("EjectsCasing", 99)) {
                this.ejectsCasing = tag.m_128471_("EjectsCasing");
            }
            if (tag.m_128425_("Visible", 99)) {
                this.visible = tag.m_128471_("Visible");
            }
            if (tag.m_128425_("IgnoresBlocks", 99)) {
                this.ignoresBlocks = tag.m_128471_("IgnoresBlocks");
            }
            if (tag.m_128425_("Damage", 99)) {
                this.damage = tag.m_128457_("Damage");
            }
            if (tag.m_128425_("HeadshotMultiplier", 99)) {
                this.headshotMultiplier = tag.m_128457_("HeadshotMultiplier");
            }
            if (tag.m_128425_("Advantage", 8)) {
                this.advantage = new ResourceLocation(tag.m_128461_("Advantage"));
            }
            if (tag.m_128425_("Size", 99)) {
                this.size = tag.m_128457_("Size");
            }
            if (tag.m_128425_("Speed", 99)) {
                this.speed = tag.m_128459_("Speed");
            }
            if (tag.m_128425_("Life", 99)) {
                this.life = tag.m_128451_("Life");
            }
            if (tag.m_128425_("Gravity", 99)) {
                this.gravity = tag.m_128471_("Gravity");
            }
            if (tag.m_128425_("DamageReduceOverLife", 99)) {
                this.damageReduceOverLife = tag.m_128471_("DamageReduceOverLife");
            }
            if (tag.m_128425_("TrailColor", 99)) {
                this.trailColor = tag.m_128451_("TrailColor");
            }
            if (tag.m_128425_("TrailLengthMultiplier", 99)) {
                this.trailLengthMultiplier = tag.m_128459_("TrailLengthMultiplier");
            }
            if (tag.m_128425_("HideTrail", 99)) {
                this.hideTrail = tag.m_128471_("HideTrail");
            }
            if (tag.m_128425_("NoProjectile", 99)) {
                this.noProjectile = tag.m_128471_("NoProjectile");
            }
            if (tag.m_128425_("HitsRubberFruit", 99)) {
                this.hitsRubberFruit = tag.m_128471_("HitsRubberFruit");
            }
        }

        public JsonObject toJsonObject() {
            Preconditions.checkArgument((this.damage >= 0.0f ? 1 : 0) != 0, (Object)"Damage must be more than or equal to zero");
            Preconditions.checkArgument((this.size >= 0.0f ? 1 : 0) != 0, (Object)"Projectile size must be more than or equal to zero");
            Preconditions.checkArgument((this.speed >= 0.0 ? 1 : 0) != 0, (Object)"Projectile speed must be more than or equal to zero");
            Preconditions.checkArgument((this.life > 0 ? 1 : 0) != 0, (Object)"Projectile life must be more than zero");
            Preconditions.checkArgument((this.trailLengthMultiplier >= 0.0 ? 1 : 0) != 0, (Object)"Projectile trail length multiplier must be more than or equal to zero");
            JsonObject object = new JsonObject();
            object.addProperty("item", this.item.toString());
            object.addProperty("headshotMultiplier", (Number)Float.valueOf(this.headshotMultiplier));
            if (this.ejectsCasing) {
                object.addProperty("ejectsCasing", Boolean.valueOf(true));
            }
            if (this.visible) {
                object.addProperty("visible", Boolean.valueOf(true));
            }
            if (this.ignoresBlocks) {
                object.addProperty("ignoresBlocks", Boolean.valueOf(true));
            }
            object.addProperty("damage", (Number)Float.valueOf(this.damage));
            if (this.advantage != null) {
                object.addProperty("advantage", this.advantage.toString());
            }
            object.addProperty("size", (Number)Float.valueOf(this.size));
            object.addProperty("speed", (Number)this.speed);
            object.addProperty("life", (Number)this.life);
            if (this.gravity) {
                object.addProperty("gravity", Boolean.valueOf(true));
            }
            if (this.damageReduceOverLife) {
                object.addProperty("damageReduceOverLife", Boolean.valueOf(this.damageReduceOverLife));
            }
            if (this.trailColor != 0xFFFF00) {
                object.addProperty("trailColor", (Number)this.trailColor);
            }
            if (this.trailLengthMultiplier != 1.0) {
                object.addProperty("trailLengthMultiplier", (Number)this.trailLengthMultiplier);
            }
            if (this.hideTrail) {
                object.addProperty("hideTrail", Boolean.valueOf(true));
            }
            if (this.noProjectile) {
                object.addProperty("noProjectile", Boolean.valueOf(true));
            }
            if (this.hitsRubberFruit) {
                object.addProperty("hitsRubberFruit", Boolean.valueOf(true));
            }
            return object;
        }

        public Projectile copy() {
            Projectile projectile = new Projectile();
            projectile.item = this.item;
            projectile.ejectsCasing = this.ejectsCasing;
            projectile.visible = this.visible;
            projectile.ignoresBlocks = this.ignoresBlocks;
            projectile.damage = this.damage;
            projectile.headshotMultiplier = this.headshotMultiplier;
            projectile.advantage = this.advantage;
            projectile.size = this.size;
            projectile.speed = this.speed;
            projectile.life = this.life;
            projectile.gravity = this.gravity;
            projectile.damageReduceOverLife = this.damageReduceOverLife;
            projectile.trailColor = this.trailColor;
            projectile.trailLengthMultiplier = this.trailLengthMultiplier;
            projectile.hideTrail = this.hideTrail;
            projectile.noProjectile = this.noProjectile;
            projectile.hitsRubberFruit = this.hitsRubberFruit;
            return projectile;
        }

        public ResourceLocation getItem() {
            return this.item;
        }

        public boolean ejectsCasing() {
            return this.ejectsCasing;
        }

        public boolean isVisible() {
            return this.visible;
        }

        public boolean ignoresBlocks() {
            return this.ignoresBlocks;
        }

        public float getDamage() {
            return this.damage;
        }

        public float getHeadshotMultiplier() {
            return this.headshotMultiplier;
        }

        public ResourceLocation getAdvantage() {
            return this.advantage;
        }

        public float getSize() {
            return this.size;
        }

        public double getSpeed() {
            return this.speed;
        }

        public int getLife() {
            return this.life;
        }

        public boolean isGravity() {
            return this.gravity;
        }

        public boolean isDamageReduceOverLife() {
            return this.damageReduceOverLife;
        }

        public int getTrailColor() {
            return this.trailColor;
        }

        public double getTrailLengthMultiplier() {
            return this.trailLengthMultiplier;
        }

        public boolean hideTrail() {
            return this.hideTrail;
        }

        public boolean hasProjectile() {
            return !this.noProjectile;
        }

        public boolean hitsRubberFruit() {
            return this.hitsRubberFruit;
        }
    }

    public static class Sounds
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Nullable
        private ResourceLocation fire;
        @Optional
        @Nullable
        private ResourceLocation reload;
        @Optional
        @Nullable
        private ResourceLocation cock;
        @Optional
        @Nullable
        private ResourceLocation silencedFire;
        @Optional
        @Nullable
        private ResourceLocation enchantedFire;
        @Optional
        @Nullable
        private ResourceLocation preFire;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.fire != null) {
                tag.m_128359_("Fire", this.fire.toString());
            }
            if (this.reload != null) {
                tag.m_128359_("Reloads", this.reload.toString());
            }
            if (this.cock != null) {
                tag.m_128359_("Cock", this.cock.toString());
            }
            if (this.silencedFire != null) {
                tag.m_128359_("SilencedFire", this.silencedFire.toString());
            }
            if (this.enchantedFire != null) {
                tag.m_128359_("EnchantedFire", this.enchantedFire.toString());
            }
            if (this.preFire != null) {
                tag.m_128359_("PreFire", this.preFire.toString());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Fire", 8)) {
                this.fire = this.createSound(tag, "Fire");
            }
            if (tag.m_128425_("Reloads", 8)) {
                this.reload = this.createSound(tag, "Reloads");
            }
            if (tag.m_128425_("Cock", 8)) {
                this.cock = this.createSound(tag, "Cock");
            }
            if (tag.m_128425_("SilencedFire", 8)) {
                this.silencedFire = this.createSound(tag, "SilencedFire");
            }
            if (tag.m_128425_("EnchantedFire", 8)) {
                this.enchantedFire = this.createSound(tag, "EnchantedFire");
            }
            if (tag.m_128425_("PreFire", 8)) {
                this.preFire = this.createSound(tag, "PreFire");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.fire != null) {
                object.addProperty("fire", this.fire.toString());
            }
            if (this.reload != null) {
                object.addProperty("reload", this.reload.toString());
            }
            if (this.cock != null) {
                object.addProperty("cock", this.cock.toString());
            }
            if (this.silencedFire != null) {
                object.addProperty("silencedFire", this.silencedFire.toString());
            }
            if (this.enchantedFire != null) {
                object.addProperty("enchantedFire", this.enchantedFire.toString());
            }
            if (this.preFire != null) {
                object.addProperty("preFire", this.preFire.toString());
            }
            return object;
        }

        public Sounds copy() {
            Sounds sounds = new Sounds();
            sounds.fire = this.fire;
            sounds.reload = this.reload;
            sounds.cock = this.cock;
            sounds.silencedFire = this.silencedFire;
            sounds.enchantedFire = this.enchantedFire;
            sounds.preFire = this.preFire;
            return sounds;
        }

        @Nullable
        private ResourceLocation createSound(CompoundTag tag, String key) {
            String sound = tag.m_128461_(key);
            return sound.isEmpty() ? null : new ResourceLocation(sound);
        }

        @Nullable
        public ResourceLocation getFire() {
            return this.fire;
        }

        @Nullable
        public ResourceLocation getReload() {
            return this.reload;
        }

        @Nullable
        public ResourceLocation getCock() {
            return this.cock;
        }

        @Nullable
        public ResourceLocation getSilencedFire() {
            return this.silencedFire;
        }

        @Nullable
        public ResourceLocation getEnchantedFire() {
            return this.enchantedFire;
        }

        @Nullable
        public ResourceLocation getPreFire() {
            return this.preFire;
        }
    }

    public static class Display
    implements INBTSerializable<CompoundTag> {
        @Optional
        @Nullable
        protected Flash flash;

        @Nullable
        public Flash getFlash() {
            return this.flash;
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.flash != null) {
                tag.m_128365_("Flash", (Tag)this.flash.serializeNBT());
            }
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Flash", 10)) {
                CompoundTag flashTag = tag.m_128469_("Flash");
                if (!flashTag.m_128456_()) {
                    Flash flash = new Flash();
                    flash.deserializeNBT(tag.m_128469_("Flash"));
                    this.flash = flash;
                } else {
                    this.flash = null;
                }
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.flash != null) {
                GunJsonUtil.addObjectIfNotEmpty(object, "flash", this.flash.toJsonObject());
            }
            return object;
        }

        public Display copy() {
            Display display = new Display();
            if (this.flash != null) {
                display.flash = this.flash.copy();
            }
            return display;
        }

        public static class Flash
        extends Positioned {
            private double size = 0.5;

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                tag.m_128347_("Size", this.size);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundTag tag) {
                super.deserializeNBT(tag);
                if (tag.m_128425_("Size", 99)) {
                    this.size = tag.m_128459_("Size");
                }
            }

            @Override
            public JsonObject toJsonObject() {
                Preconditions.checkArgument((this.size >= 0.0 ? 1 : 0) != 0, (Object)"Muzzle flash size must be more than or equal to zero");
                JsonObject object = super.toJsonObject();
                if (this.size != 0.5) {
                    object.addProperty("size", (Number)this.size);
                }
                return object;
            }

            @Override
            public Flash copy() {
                Flash flash = new Flash();
                flash.size = this.size;
                flash.xOffset = this.xOffset;
                flash.yOffset = this.yOffset;
                flash.zOffset = this.zOffset;
                return flash;
            }

            public double getSize() {
                return this.size;
            }
        }
    }

    public static class Modules
    implements INBTSerializable<CompoundTag>,
    IEditorMenu {
        private transient Zoom cachedZoom;
        @Optional
        @Nullable
        private Zoom zoom;
        private Attachments attachments = new Attachments();

        @Nullable
        public Zoom getZoom() {
            return this.zoom;
        }

        public Attachments getAttachments() {
            return this.attachments;
        }

        @Override
        public Component getEditorLabel() {
            return Component.m_237115_((String)"Modules");
        }

        @Override
        public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
                widgets.add(Pair.of((Object)Component.m_237115_((String)"Enabled Iron Sights"), () -> new DebugToggle(this.zoom != null, val -> {
                    if (val.booleanValue()) {
                        if (this.cachedZoom != null) {
                            this.zoom = this.cachedZoom;
                        } else {
                            this.cachedZoom = this.zoom = new Zoom();
                        }
                    } else {
                        this.cachedZoom = this.zoom;
                        this.zoom = null;
                    }
                })));
                widgets.add(Pair.of((Object)Component.m_237115_((String)"Adjust Iron Sights"), () -> new DebugButton((Component)Component.m_237115_((String)">"), btn -> {
                    if (btn.f_93623_ && this.zoom != null) {
                        Minecraft.m_91087_().m_91152_(ClientHandler.createEditorScreen(this.zoom));
                    }
                }, () -> this.zoom != null)));
            });
        }

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            if (this.zoom != null) {
                tag.m_128365_("Zoom", (Tag)this.zoom.serializeNBT());
            }
            tag.m_128365_("Attachments", (Tag)this.attachments.serializeNBT());
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("Zoom", 10)) {
                Zoom zoom = new Zoom();
                zoom.deserializeNBT(tag.m_128469_("Zoom"));
                this.zoom = zoom;
            }
            if (tag.m_128425_("Attachments", 10)) {
                this.attachments.deserializeNBT(tag.m_128469_("Attachments"));
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.zoom != null) {
                object.add("zoom", (JsonElement)this.zoom.toJsonObject());
            }
            GunJsonUtil.addObjectIfNotEmpty(object, "attachments", this.attachments.toJsonObject());
            return object;
        }

        public Modules copy() {
            Modules modules = new Modules();
            if (this.zoom != null) {
                modules.zoom = this.zoom.copy();
            }
            modules.attachments = this.attachments.copy();
            return modules;
        }

        public static class Attachments
        implements INBTSerializable<CompoundTag> {
            @Optional
            @Nullable
            private ScaledPositioned scope;
            @Optional
            @Nullable
            private ScaledPositioned barrel;
            @Optional
            @Nullable
            private ScaledPositioned stock;
            @Optional
            @Nullable
            private ScaledPositioned underBarrel;
            @Optional
            @Nullable
            private ScaledPositioned magazine;
            @Optional
            @Nullable
            private ScaledPositioned side;

            @Nullable
            public ScaledPositioned getScope() {
                return this.scope;
            }

            @Nullable
            public ScaledPositioned getBarrel() {
                return this.barrel;
            }

            @Nullable
            public ScaledPositioned getStock() {
                return this.stock;
            }

            @Nullable
            public ScaledPositioned getUnderBarrel() {
                return this.underBarrel;
            }

            @Nullable
            public ScaledPositioned getMagazine() {
                return this.magazine;
            }

            @Nullable
            public ScaledPositioned getSide() {
                return this.side;
            }

            public CompoundTag serializeNBT() {
                CompoundTag tag = new CompoundTag();
                if (this.scope != null) {
                    tag.m_128365_("Scope", (Tag)this.scope.serializeNBT());
                }
                if (this.barrel != null) {
                    tag.m_128365_("Barrel", (Tag)this.barrel.serializeNBT());
                }
                if (this.stock != null) {
                    tag.m_128365_("Stock", (Tag)this.stock.serializeNBT());
                }
                if (this.underBarrel != null) {
                    tag.m_128365_("UnderBarrel", (Tag)this.underBarrel.serializeNBT());
                }
                if (this.magazine != null) {
                    tag.m_128365_("Magazine", (Tag)this.magazine.serializeNBT());
                }
                if (this.side != null) {
                    tag.m_128365_("Side", (Tag)this.side.serializeNBT());
                }
                return tag;
            }

            public void deserializeNBT(CompoundTag tag) {
                if (tag.m_128425_("Scope", 10)) {
                    this.scope = this.createScaledPositioned(tag, "Scope");
                }
                if (tag.m_128425_("Barrel", 10)) {
                    this.barrel = this.createScaledPositioned(tag, "Barrel");
                }
                if (tag.m_128425_("Stock", 10)) {
                    this.stock = this.createScaledPositioned(tag, "Stock");
                }
                if (tag.m_128425_("UnderBarrel", 10)) {
                    this.underBarrel = this.createScaledPositioned(tag, "UnderBarrel");
                }
                if (tag.m_128425_("Magazine", 10)) {
                    this.magazine = this.createScaledPositioned(tag, "Magazine");
                }
                if (tag.m_128425_("Side", 10)) {
                    this.side = this.createScaledPositioned(tag, "Side");
                }
            }

            public JsonObject toJsonObject() {
                JsonObject object = new JsonObject();
                if (this.scope != null) {
                    object.add("scope", (JsonElement)this.scope.toJsonObject());
                }
                if (this.barrel != null) {
                    object.add("barrel", (JsonElement)this.barrel.toJsonObject());
                }
                if (this.stock != null) {
                    object.add("stock", (JsonElement)this.stock.toJsonObject());
                }
                if (this.underBarrel != null) {
                    object.add("underBarrel", (JsonElement)this.underBarrel.toJsonObject());
                }
                if (this.magazine != null) {
                    object.add("magazine", (JsonElement)this.magazine.toJsonObject());
                }
                if (this.side != null) {
                    object.add("side", (JsonElement)this.side.toJsonObject());
                }
                return object;
            }

            public Attachments copy() {
                Attachments attachments = new Attachments();
                if (this.scope != null) {
                    attachments.scope = this.scope.copy();
                }
                if (this.barrel != null) {
                    attachments.barrel = this.barrel.copy();
                }
                if (this.stock != null) {
                    attachments.stock = this.stock.copy();
                }
                if (this.underBarrel != null) {
                    attachments.underBarrel = this.underBarrel.copy();
                }
                if (this.magazine != null) {
                    attachments.magazine = this.magazine.copy();
                }
                if (this.side != null) {
                    attachments.side = this.side.copy();
                }
                return attachments;
            }

            @Nullable
            private ScaledPositioned createScaledPositioned(CompoundTag tag, String key) {
                CompoundTag attachment = tag.m_128469_(key);
                return attachment.m_128456_() ? null : new ScaledPositioned(attachment);
            }
        }

        public static class Zoom
        extends Positioned
        implements IEditorMenu {
            @Optional
            private float fovModifier;

            @Override
            public CompoundTag serializeNBT() {
                CompoundTag tag = super.serializeNBT();
                tag.m_128350_("FovModifier", this.fovModifier);
                return tag;
            }

            @Override
            public void deserializeNBT(CompoundTag tag) {
                super.deserializeNBT(tag);
                if (tag.m_128425_("FovModifier", 99)) {
                    this.fovModifier = tag.m_128457_("FovModifier");
                }
            }

            @Override
            public JsonObject toJsonObject() {
                JsonObject object = super.toJsonObject();
                object.addProperty("fovModifier", (Number)Float.valueOf(this.fovModifier));
                return object;
            }

            @Override
            public Zoom copy() {
                Zoom zoom = new Zoom();
                zoom.fovModifier = this.fovModifier;
                zoom.xOffset = this.xOffset;
                zoom.yOffset = this.yOffset;
                zoom.zOffset = this.zOffset;
                return zoom;
            }

            @Override
            public Component getEditorLabel() {
                return Component.m_237115_((String)"Zoom");
            }

            @Override
            public void getEditorWidgets(List<Pair<Component, Supplier<IDebugWidget>>> widgets) {
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> widgets.add(Pair.of((Object)Component.m_237115_((String)"FOV Modifier"), () -> new DebugSlider(0.0, 1.0, this.fovModifier, 0.01, 3, val -> {
                    this.fovModifier = val.floatValue();
                }))));
            }

            public float getFovModifier() {
                return this.fovModifier;
            }

            public static Builder builder() {
                return new Builder();
            }

            public static class Builder
            extends AbstractBuilder<Builder> {
            }

            protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
            extends Positioned.AbstractBuilder<T> {
                protected final Zoom zoom;

                protected AbstractBuilder() {
                    this(new Zoom());
                }

                protected AbstractBuilder(Zoom zoom) {
                    super(zoom);
                    this.zoom = zoom;
                }

                public T setFovModifier(float fovModifier) {
                    this.zoom.fovModifier = fovModifier;
                    return (T)((AbstractBuilder)this.self());
                }

                @Override
                public Zoom build() {
                    return this.zoom.copy();
                }
            }
        }
    }

    public static class ScaledPositioned
    extends Positioned {
        @Optional
        protected double scale = 1.0;

        public ScaledPositioned() {
        }

        public ScaledPositioned(CompoundTag tag) {
            this.deserializeNBT(tag);
        }

        @Override
        public CompoundTag serializeNBT() {
            CompoundTag tag = super.serializeNBT();
            tag.m_128347_("Scale", this.scale);
            return tag;
        }

        @Override
        public void deserializeNBT(CompoundTag tag) {
            super.deserializeNBT(tag);
            if (tag.m_128425_("Scale", 99)) {
                this.scale = tag.m_128459_("Scale");
            }
        }

        @Override
        public JsonObject toJsonObject() {
            JsonObject object = super.toJsonObject();
            if (this.scale != 1.0) {
                object.addProperty("scale", (Number)this.scale);
            }
            return object;
        }

        public double getScale() {
            return this.scale;
        }

        @Override
        public ScaledPositioned copy() {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            positioned.scale = this.scale;
            return positioned;
        }
    }

    public static class Builder {
        private final Gun gun = new Gun();

        private Builder() {
        }

        public static Builder create() {
            return new Builder();
        }

        public Gun build() {
            return this.gun.copy();
        }

        public Builder setFireMode(FireMode fireMode) {
            this.gun.general.fireMode = fireMode;
            return this;
        }

        public Builder setBurstAmount(int burstAmount) {
            this.gun.general.burstAmount = burstAmount;
            return this;
        }

        public Builder setBurstDelay(int burstDelay) {
            this.gun.general.burstDelay = burstDelay;
            return this;
        }

        public Builder setFireRate(int rate) {
            this.gun.general.rate = rate;
            return this;
        }

        public Builder setFireTimer(int fireTimer) {
            this.gun.general.fireTimer = fireTimer;
            return this;
        }

        public Builder setSilenced(boolean silenced) {
            this.gun.general.silenced = silenced;
            return this;
        }

        public Builder setCustomFiring(boolean customFiring) {
            this.gun.general.customFiring = customFiring;
            return this;
        }

        public Builder setGripType(GripType gripType) {
            this.gun.general.gripType = gripType;
            return this;
        }

        public Builder setReloadItem(Item item) {
            this.gun.reloads.reloadItem = ForgeRegistries.ITEMS.getKey((Object)item);
            return this;
        }

        public Builder setMaxAmmo(int maxAmmo) {
            this.gun.reloads.maxAmmo = maxAmmo;
            return this;
        }

        public Builder setReloadType(ReloadType reloadType) {
            this.gun.reloads.reloadType = reloadType;
            return this;
        }

        public Builder setReloadTimer(int reloadTimer) {
            this.gun.reloads.reloadTimer = reloadTimer;
            return this;
        }

        public Builder setEmptyMagTimer(int emptyMagTimer) {
            this.gun.reloads.emptyMagTimer = emptyMagTimer;
            return this;
        }

        public Builder setReloadAmount(int reloadAmount) {
            this.gun.reloads.reloadAmount = reloadAmount;
            return this;
        }

        public Builder setRecoilAngle(float recoilAngle) {
            this.gun.general.recoilAngle = recoilAngle;
            return this;
        }

        public Builder setRecoilKick(float recoilKick) {
            this.gun.general.recoilKick = recoilKick;
            return this;
        }

        public Builder setRecoilDurationOffset(float recoilDurationOffset) {
            this.gun.general.recoilDurationOffset = recoilDurationOffset;
            return this;
        }

        public Builder setRecoilAdsReduction(float recoilAdsReduction) {
            this.gun.general.recoilAdsReduction = recoilAdsReduction;
            return this;
        }

        public Builder setProjectileAmount(int projectileAmount) {
            this.gun.general.projectileAmount = projectileAmount;
            return this;
        }

        public Builder setAlwaysSpread(boolean alwaysSpread) {
            this.gun.general.alwaysSpread = alwaysSpread;
            return this;
        }

        public Builder setSpread(float spread) {
            this.gun.general.spread = spread;
            return this;
        }

        public Builder setCanBeBlueprinted(boolean canBeBlueprinted) {
            this.gun.general.canBeBlueprinted = canBeBlueprinted;
            return this;
        }

        public Builder setInfinityDisabled(boolean infinityDisabled) {
            this.gun.general.infinityDisabled = infinityDisabled;
            return this;
        }

        public Builder setCanFireUnderwater(boolean canFireUnderwater) {
            this.gun.general.canFireUnderwater = canFireUnderwater;
            return this;
        }

        public Builder setAmmo(Item item) {
            this.gun.projectile.item = ForgeRegistries.ITEMS.getKey((Object)item);
            return this;
        }

        public Builder setEjectsCasing(boolean ejectsCasing) {
            this.gun.projectile.ejectsCasing = ejectsCasing;
            return this;
        }

        public Builder setProjectileVisible(boolean visible) {
            this.gun.projectile.visible = visible;
            return this;
        }

        public Builder setProjectileSize(float size) {
            this.gun.projectile.size = size;
            return this;
        }

        public Builder setProjectileSpeed(double speed) {
            this.gun.projectile.speed = speed;
            return this;
        }

        public Builder setProjectileLife(int life) {
            this.gun.projectile.life = life;
            return this;
        }

        public Builder setProjectileAffectedByGravity(boolean gravity) {
            this.gun.projectile.gravity = gravity;
            return this;
        }

        public Builder setProjectileTrailColor(int trailColor) {
            this.gun.projectile.trailColor = trailColor;
            return this;
        }

        public Builder setProjectileTrailLengthMultiplier(int trailLengthMultiplier) {
            this.gun.projectile.trailLengthMultiplier = trailLengthMultiplier;
            return this;
        }

        public Builder setHideTrail(boolean hideTrail) {
            this.gun.projectile.hideTrail = hideTrail;
            return this;
        }

        public Builder setNoProjectile(boolean noProjectile) {
            this.gun.projectile.noProjectile = noProjectile;
            return this;
        }

        public Builder setHitsRubberFruit(boolean hitsRubberFruit) {
            this.gun.projectile.hitsRubberFruit = hitsRubberFruit;
            return this;
        }

        public Builder setIgnoresBlocks(boolean ignoresBlocks) {
            this.gun.projectile.ignoresBlocks = ignoresBlocks;
            return this;
        }

        public Builder setDamage(float damage) {
            this.gun.projectile.damage = damage;
            return this;
        }

        public Builder setHeadshotMultiplier(float headshotMultiplier) {
            this.gun.projectile.headshotMultiplier = headshotMultiplier;
            return this;
        }

        public Builder setAdvantage(ResourceLocation advantage) {
            this.gun.projectile.advantage = advantage;
            return this;
        }

        public Builder setReduceDamageOverLife(boolean damageReduceOverLife) {
            this.gun.projectile.damageReduceOverLife = damageReduceOverLife;
            return this;
        }

        public Builder setFireSound(SoundEvent sound) {
            this.gun.sounds.fire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setReloadSound(SoundEvent sound) {
            this.gun.sounds.reload = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setCockSound(SoundEvent sound) {
            this.gun.sounds.cock = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setSilencedFireSound(SoundEvent sound) {
            this.gun.sounds.silencedFire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setEnchantedFireSound(SoundEvent sound) {
            this.gun.sounds.enchantedFire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setPreFireSound(SoundEvent sound) {
            this.gun.sounds.preFire = ForgeRegistries.SOUND_EVENTS.getKey((Object)sound);
            return this;
        }

        public Builder setMuzzleFlash(double size, double xOffset, double yOffset, double zOffset) {
            Display.Flash flash = new Display.Flash();
            flash.size = size;
            flash.xOffset = xOffset;
            flash.yOffset = yOffset;
            flash.zOffset = zOffset;
            this.gun.display.flash = flash;
            return this;
        }

        public Builder setZoom(float fovModifier, double xOffset, double yOffset, double zOffset) {
            Modules.Zoom zoom = new Modules.Zoom();
            zoom.fovModifier = fovModifier;
            zoom.xOffset = xOffset;
            zoom.yOffset = yOffset;
            zoom.zOffset = zOffset;
            this.gun.modules.zoom = zoom;
            return this;
        }

        public Builder setZoom(Modules.Zoom.Builder builder) {
            this.gun.modules.zoom = builder.build();
            return this;
        }

        public Builder setScope(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.scope = positioned;
            return this;
        }

        public Builder setBarrel(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.barrel = positioned;
            return this;
        }

        public Builder setStock(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.stock = positioned;
            return this;
        }

        public Builder setUnderBarrel(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.underBarrel = positioned;
            return this;
        }

        public Builder setMagazine(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.magazine = positioned;
            return this;
        }

        public Builder setSide(float scale, double xOffset, double yOffset, double zOffset) {
            ScaledPositioned positioned = new ScaledPositioned();
            positioned.scale = scale;
            positioned.xOffset = xOffset;
            positioned.yOffset = yOffset;
            positioned.zOffset = zOffset;
            this.gun.modules.attachments.side = positioned;
            return this;
        }
    }

    public static class Positioned
    implements INBTSerializable<CompoundTag> {
        @Optional
        protected double xOffset;
        @Optional
        protected double yOffset;
        @Optional
        protected double zOffset;

        public CompoundTag serializeNBT() {
            CompoundTag tag = new CompoundTag();
            tag.m_128347_("XOffset", this.xOffset);
            tag.m_128347_("YOffset", this.yOffset);
            tag.m_128347_("ZOffset", this.zOffset);
            return tag;
        }

        public void deserializeNBT(CompoundTag tag) {
            if (tag.m_128425_("XOffset", 99)) {
                this.xOffset = tag.m_128459_("XOffset");
            }
            if (tag.m_128425_("YOffset", 99)) {
                this.yOffset = tag.m_128459_("YOffset");
            }
            if (tag.m_128425_("ZOffset", 99)) {
                this.zOffset = tag.m_128459_("ZOffset");
            }
        }

        public JsonObject toJsonObject() {
            JsonObject object = new JsonObject();
            if (this.xOffset != 0.0) {
                object.addProperty("xOffset", (Number)this.xOffset);
            }
            if (this.yOffset != 0.0) {
                object.addProperty("yOffset", (Number)this.yOffset);
            }
            if (this.zOffset != 0.0) {
                object.addProperty("zOffset", (Number)this.zOffset);
            }
            return object;
        }

        public double getXOffset() {
            return this.xOffset;
        }

        public double getYOffset() {
            return this.yOffset;
        }

        public double getZOffset() {
            return this.zOffset;
        }

        public Positioned copy() {
            Positioned positioned = new Positioned();
            positioned.xOffset = this.xOffset;
            positioned.yOffset = this.yOffset;
            positioned.zOffset = this.zOffset;
            return positioned;
        }

        protected static abstract class AbstractBuilder<T extends AbstractBuilder<T>>
        extends SuperBuilder<Positioned, T> {
            private final Positioned positioned;

            private AbstractBuilder() {
                this(new Positioned());
            }

            protected AbstractBuilder(Positioned positioned) {
                this.positioned = positioned;
            }

            public T setOffset(double xOffset, double yOffset, double zOffset) {
                this.positioned.xOffset = xOffset;
                this.positioned.yOffset = yOffset;
                this.positioned.zOffset = zOffset;
                return (T)((AbstractBuilder)this.self());
            }

            public T setXOffset(double xOffset) {
                this.positioned.xOffset = xOffset;
                return (T)((AbstractBuilder)this.self());
            }

            public T setYOffset(double yOffset) {
                this.positioned.yOffset = yOffset;
                return (T)((AbstractBuilder)this.self());
            }

            public T setZOffset(double zOffset) {
                this.positioned.zOffset = zOffset;
                return (T)((AbstractBuilder)this.self());
            }

            @Override
            public Positioned build() {
                return this.positioned.copy();
            }
        }

        public static class Builder
        extends AbstractBuilder<Builder> {
        }
    }
}

