/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.entity.projectile;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ModTags;
import ttv.migami.jeg.common.network.ServerPlayHandler;
import ttv.migami.jeg.entity.projectile.ProjectileEntity;
import ttv.migami.jeg.init.ModParticleTypes;
import ttv.migami.jeg.item.GunItem;

public class RocketEntity
extends ProjectileEntity {
    private boolean explosionScheduled = false;
    private boolean explosionForceNone = false;

    public RocketEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public RocketEntity(EntityType<? extends ProjectileEntity> entityType, Level worldIn, LivingEntity shooter, ItemStack weapon, GunItem item, Gun modifiedGun) {
        super(entityType, worldIn, shooter, weapon, item, modifiedGun);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.explosionScheduled) {
            RocketEntity.createExplosion(this, ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue(), this.explosionForceNone);
            this.m_142687_(Entity.RemovalReason.KILLED);
            this.explosionScheduled = false;
        }
    }

    @Override
    protected void onProjectileTick() {
        if (this.m_9236_().f_46443_ && this.f_19797_ > 3) {
            for (int i = 5; i > 0; --i) {
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123777_, true, this.m_20185_() - this.m_20184_().m_7096_() / (double)i, this.m_20186_() - this.m_20184_().m_7098_() / (double)i, this.m_20189_() - this.m_20184_().m_7094_() / (double)i, 0.0, 0.0, 0.0);
            }
            if (this.m_9236_().f_46441_.m_188503_(2) == 0) {
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIRE.get(), true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123756_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_9236_().m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    protected void impactEffect() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            ServerPlayHandler.sendParticlesToAll(serverLevel, (SimpleParticleType)ModParticleTypes.BIG_EXPLOSION.get(), true, this.m_20185_() - this.m_20184_().m_7096_(), this.m_20186_() - this.m_20184_().m_7098_(), this.m_20189_() - this.m_20184_().m_7094_(), 1, 0.0, 0.0, 0.0, 0.0);
        }
        if (this.m_9236_().f_46443_) {
            double posX = this.m_20185_() - this.m_20184_().m_7096_();
            double posY = this.m_20186_() - this.m_20184_().m_7098_();
            double posZ = this.m_20189_() - this.m_20184_().m_7094_();
            for (int i = 0; i < 10; ++i) {
                double xSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double ySpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                double zSpeed = (this.f_19796_.m_188500_() - 0.5) * 0.5 * 10.0;
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.SMOKE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
                this.m_9236_().m_6493_((ParticleOptions)ModParticleTypes.FIRE.get(), true, posX, posY + 2.0, posZ, xSpeed, ySpeed, zSpeed);
            }
        }
    }

    @Override
    protected void onHitEntity(Entity entity, Vec3 hitVec, Vec3 startVec, Vec3 endVec, boolean headshot) {
        boolean forceNone;
        boolean bl = forceNone = !(this.getShooter() instanceof Player);
        if (!entity.m_6095_().m_204039_(ModTags.Entities.HEAVY) && !entity.m_6095_().m_204039_(ModTags.Entities.VERY_HEAVY)) {
            if (this.f_19797_ <= 5 && this.m_20197_().isEmpty()) {
                entity.m_20329_((Entity)this);
            } else {
                this.setExplosionScheduled(true, forceNone);
            }
        } else {
            RocketEntity.createExplosion(this, ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue(), forceNone);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public void setExplosionScheduled(boolean scheduled, boolean forceNone) {
        this.explosionScheduled = scheduled;
        this.explosionForceNone = forceNone;
    }

    @Override
    protected void onHitBlock(BlockState state, BlockPos pos, Direction face, double x, double y, double z) {
        boolean forceNone = !(this.getShooter() instanceof Player);
        RocketEntity.createExplosion(this, ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue(), forceNone);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    @Override
    public void onExpired() {
        boolean forceNone = !(this.getShooter() instanceof Player);
        RocketEntity.createExplosion(this, ((Double)Config.COMMON.missiles.explosionRadius.get()).floatValue(), forceNone);
        this.m_142687_(Entity.RemovalReason.KILLED);
    }
}

