/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.event;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.common.GripType;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.init.ModBlocks;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.FlashlightItem;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.S2CMessageLaser;

@Mod.EventBusSubscriber(modid="jeg", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class FlashlightEvent {
    @SubscribeEvent
    public static void laserPointer(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        boolean isAiming = (Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player);
        if (!player.m_9236_().f_46443_ && !player.m_5833_() && player.m_21205_().m_41720_() instanceof GunItem && Gun.hasAttachmentEquipped(player.m_21205_(), IAttachment.Type.SIDE) && Gun.getAttachment(IAttachment.Type.SIDE, player.m_21205_()).m_41720_() == ModItems.LASER_POINTER.get()) {
            Vec3 userPos = player.m_146892_();
            Vec3 targetPos = userPos.m_82549_(player.m_20154_().m_82490_(100.0));
            BlockHitResult blockResult = player.m_9236_().m_45547_(new ClipContext(userPos, targetPos, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
            EntityHitResult entityResult = FlashlightEvent.rayTraceEntities(player, userPos, targetPos, 100.0);
            Vec3 laserEndPos = null;
            if (entityResult != null && (blockResult == null || userPos.m_82554_(entityResult.m_82450_()) < userPos.m_82554_(blockResult.m_82450_()))) {
                laserEndPos = entityResult.m_82450_();
                Entity hitEntity = entityResult.m_82443_();
                if (hitEntity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)hitEntity;
                    if (((Boolean)Config.COMMON.gameplay.glowingLaserPointers.get()).booleanValue() && isAiming) {
                        livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 5, 0, false, false, true));
                    }
                }
            } else if (blockResult instanceof BlockHitResult) {
                BlockHitResult blockHitResult = blockResult;
                laserEndPos = blockHitResult.m_82450_();
                Direction face = blockHitResult.m_82434_();
                PacketHandler.getPlayChannel().sendToTrackingChunk(() -> player.m_9236_().m_46745_(blockHitResult.m_82425_()), (IMessage)new S2CMessageLaser(blockHitResult.m_82450_().f_82479_, blockHitResult.m_82450_().f_82480_, blockHitResult.m_82450_().f_82481_, blockHitResult.m_82425_(), face));
            }
            List<Class<Ocelot>> mobTypes = List.of(Cat.class, Ocelot.class);
            for (Class<Ocelot> mobType : mobTypes) {
                List mobs = player.m_9236_().m_45976_(mobType, new AABB(laserEndPos.m_82492_(5.0, 5.0, 5.0), laserEndPos.m_82520_(5.0, 5.0, 5.0)));
                for (PathfinderMob mob : mobs) {
                    Cat cat;
                    if (!(mob instanceof Cat) || (cat = (Cat)mob).m_21825_()) continue;
                    if ((double)mob.m_217043_().m_188501_() < 0.02) {
                        mob.m_21569_().m_24901_();
                    }
                    mob.m_21573_().m_26519_(laserEndPos.f_82479_, laserEndPos.f_82480_, laserEndPos.f_82481_, 1.2);
                }
            }
        }
    }

    @SubscribeEvent
    public static void flashlight(TickEvent.PlayerTickEvent event) {
        Player player = event.player;
        Level world = player.m_9236_();
        if (world.m_5776_()) {
            return;
        }
        if (player.m_21224_()) {
            return;
        }
        if (!((Boolean)Config.COMMON.gameplay.allowFlashlights.get()).booleanValue()) {
            MutableComponent message = Component.m_237115_((String)"chat.jeg.disabled_flashlights").m_130940_(ChatFormatting.GRAY);
            player.m_5661_((Component)message, true);
            return;
        }
        boolean attachment = false;
        if (Gun.hasAttachmentEquipped(player.m_21205_(), IAttachment.Type.SIDE)) {
            if (Gun.getAttachment(IAttachment.Type.SIDE, player.m_21205_()).m_41720_() == ModItems.FLASHLIGHT.get()) {
                ItemStack flashlight = Gun.getAttachment(IAttachment.Type.SIDE, player.m_21205_());
                if (flashlight.m_41783_() != null && flashlight.m_41783_().m_128471_("Powered")) {
                    attachment = true;
                }
            } else {
                attachment = false;
            }
        } else {
            attachment = false;
        }
        if (player.m_21205_().m_41619_()) {
            attachment = false;
        }
        boolean item = false;
        boolean rightHand = false;
        boolean leftHand = false;
        rightHand = player.m_21205_().m_41720_() == ModItems.FLASHLIGHT.get() ? player.m_21205_().m_41783_() != null && player.m_21205_().m_41783_().m_128471_("Powered") : false;
        if (player.m_21206_().m_41720_() == ModItems.FLASHLIGHT.get()) {
            GunItem gunItem;
            Item item2 = player.m_21205_().m_41720_();
            if (item2 instanceof GunItem && !(gunItem = (GunItem)item2).getGun().getGeneral().getGripType().equals(GripType.ONE_HANDED) && !attachment) {
                return;
            }
            leftHand = player.m_21206_().m_41783_() != null && player.m_21206_().m_41783_().m_128471_("Powered");
        } else {
            leftHand = false;
        }
        if (rightHand || leftHand) {
            item = true;
        }
        if ((attachment || item) && !player.m_5833_()) {
            double distance = 2.0;
            for (int index = 0; index < (Integer)Config.COMMON.gameplay.flashlightDistance.get(); ++index) {
                BlockPos targetPos = player.m_9236_().m_45547_(new ClipContext(player.m_20299_(1.0f), player.m_20299_(1.0f).m_82549_(player.m_20252_(1.0f).m_82490_(distance)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82425_();
                BlockState targetState = world.m_8055_(targetPos);
                if (targetState.m_60734_() == ModBlocks.DYNAMIC_LIGHT.get()) {
                    if (FlashlightEvent.getValue((LevelAccessor)world, targetPos, "Delay") < 5.0) {
                        FlashlightEvent.updateDelayAndNotify((LevelAccessor)world, targetPos, targetState);
                    }
                } else if (targetState.m_60734_() == Blocks.f_50016_ || targetState.m_60734_() == Blocks.f_50627_) {
                    BlockState dynamicLightState = ((Block)ModBlocks.DYNAMIC_LIGHT.get()).m_49966_();
                    world.m_7731_(targetPos, dynamicLightState, 3);
                }
                distance += 1.0;
            }
        }
    }

    public static void chargeFlashlight(Player player) {
        ItemStack heldItem = player.m_21205_();
        if (!(heldItem.m_41720_() instanceof FlashlightItem)) {
            return;
        }
        CompoundTag tag = heldItem.m_41784_();
        int batteryLife = tag.m_128451_("BatteryLife");
        batteryLife = Math.min(batteryLife + 40, 600);
        tag.m_128405_("BatteryLife", batteryLife);
        player.m_9236_().m_220400_((Entity)player, GameEvent.f_223699_, player.m_20318_(1.0f));
        float randomPitch = 0.9f + player.m_217043_().m_188501_() * 0.25f;
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.FLASHLIGHT_CHARGE.get(), SoundSource.PLAYERS, 1.0f, randomPitch);
    }

    private static void updateDelayAndNotify(LevelAccessor world, BlockPos pos, BlockState state) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity != null) {
            blockEntity.getPersistentData().m_128347_("Delay", 5.0);
        }
        if (world instanceof Level) {
            ((Level)world).m_7260_(pos, state, state, 3);
        }
    }

    public static double getValue(LevelAccessor world, BlockPos pos, String tag) {
        BlockEntity blockEntity = world.m_7702_(pos);
        return blockEntity != null ? blockEntity.getPersistentData().m_128459_(tag) : -1.0;
    }

    private static BlockHitResult rayTraceBlocks(Level world, ClipContext context, Predicate<BlockState> ignorePredicate) {
        return FlashlightEvent.performRayTrace(context, (rayTraceContext, blockPos) -> {
            BlockState blockState = world.m_8055_(blockPos);
            if (ignorePredicate.test(blockState)) {
                return null;
            }
            FluidState fluidState = world.m_6425_(blockPos);
            Vec3 startVec = rayTraceContext.m_45702_();
            Vec3 endVec = rayTraceContext.m_45693_();
            VoxelShape blockShape = rayTraceContext.m_45694_(blockState, (BlockGetter)world, blockPos);
            BlockHitResult blockResult = world.m_45558_(startVec, endVec, blockPos, blockShape, blockState);
            VoxelShape fluidShape = rayTraceContext.m_45698_(fluidState, (BlockGetter)world, blockPos);
            BlockHitResult fluidResult = fluidShape.m_83220_(startVec, endVec, blockPos);
            double blockDistance = blockResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(blockResult.m_82450_());
            double fluidDistance = fluidResult == null ? Double.MAX_VALUE : rayTraceContext.m_45702_().m_82557_(fluidResult.m_82450_());
            return blockDistance <= fluidDistance ? blockResult : fluidResult;
        }, rayTraceContext -> {
            Vec3 Vector3d = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)Vector3d.f_82479_, (double)Vector3d.f_82480_, (double)Vector3d.f_82481_), (BlockPos)BlockPos.m_274446_((Position)rayTraceContext.m_45693_()));
        });
    }

    private static EntityHitResult rayTraceEntities(Player player, Vec3 start, Vec3 end, double range) {
        Level level = player.m_9236_();
        Vec3 direction = end.m_82546_(start).m_82541_();
        AABB box = new AABB(start, start).m_82400_(range);
        EntityHitResult closestEntityHitResult = null;
        double closestDistance = range;
        for (Entity entity : level.m_6249_((Entity)player, box, e -> e.m_6087_())) {
            double distance;
            AABB entityBox = entity.m_20191_().m_82400_(0.3);
            Optional hitPos = entityBox.m_82371_(start, end);
            if (!hitPos.isPresent() || !((distance = start.m_82554_((Vec3)hitPos.get())) < closestDistance)) continue;
            closestEntityHitResult = new EntityHitResult(entity, (Vec3)hitPos.get());
            closestDistance = distance;
        }
        return closestEntityHitResult;
    }

    private static <T> T performRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> hitFunction, Function<ClipContext, T> p_217300_2_) {
        int blockZ;
        int blockY;
        Vec3 endVec;
        Vec3 startVec = context.m_45702_();
        if (startVec.equals((Object)(endVec = context.m_45693_()))) {
            return p_217300_2_.apply(context);
        }
        double startX = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82479_, (double)startVec.f_82479_);
        double startY = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82480_, (double)startVec.f_82480_);
        double startZ = Mth.m_14139_((double)-1.0E-7, (double)endVec.f_82481_, (double)startVec.f_82481_);
        double endX = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82479_, (double)endVec.f_82479_);
        double endY = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82480_, (double)endVec.f_82480_);
        double endZ = Mth.m_14139_((double)-1.0E-7, (double)startVec.f_82481_, (double)endVec.f_82481_);
        int blockX = Mth.m_14107_((double)endX);
        BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(blockX, blockY = Mth.m_14107_((double)endY), blockZ = Mth.m_14107_((double)endZ));
        T t = hitFunction.apply(context, (BlockPos)mutablePos);
        if (t != null) {
            return t;
        }
        double deltaX = startX - endX;
        double deltaY = startY - endY;
        double deltaZ = startZ - endZ;
        int signX = Mth.m_14205_((double)deltaX);
        int signY = Mth.m_14205_((double)deltaY);
        int signZ = Mth.m_14205_((double)deltaZ);
        double d9 = signX == 0 ? Double.MAX_VALUE : (double)signX / deltaX;
        double d10 = signY == 0 ? Double.MAX_VALUE : (double)signY / deltaY;
        double d11 = signZ == 0 ? Double.MAX_VALUE : (double)signZ / deltaZ;
        double d12 = d9 * (signX > 0 ? 1.0 - Mth.m_14185_((double)endX) : Mth.m_14185_((double)endX));
        double d13 = d10 * (signY > 0 ? 1.0 - Mth.m_14185_((double)endY) : Mth.m_14185_((double)endY));
        double d14 = d11 * (signZ > 0 ? 1.0 - Mth.m_14185_((double)endZ) : Mth.m_14185_((double)endZ));
        while (d12 <= 1.0 || d13 <= 1.0 || d14 <= 1.0) {
            T t1;
            if (d12 < d13) {
                if (d12 < d14) {
                    blockX += signX;
                    d12 += d9;
                } else {
                    blockZ += signZ;
                    d14 += d11;
                }
            } else if (d13 < d14) {
                blockY += signY;
                d13 += d10;
            } else {
                blockZ += signZ;
                d14 += d11;
            }
            if ((t1 = hitFunction.apply(context, (BlockPos)mutablePos.m_122178_(blockX, blockY, blockZ))) == null) continue;
            return t1;
        }
        return p_217300_2_.apply(context);
    }
}

