/*
 * Decompiled with CFR 0.152.
 */
package ttv.migami.jeg.item;

import com.mrcrayfish.framework.network.message.IMessage;
import java.util.function.Consumer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.cache.AnimatableIdCache;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animatable.instance.SingletonAnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.core.animation.AnimationController;
import software.bernie.geckolib.core.animation.AnimationState;
import software.bernie.geckolib.core.keyframe.event.ParticleKeyframeEvent;
import software.bernie.geckolib.core.keyframe.event.SoundKeyframeEvent;
import software.bernie.geckolib.core.object.PlayState;
import software.bernie.geckolib.util.ClientUtils;
import ttv.migami.jeg.Config;
import ttv.migami.jeg.animations.GunAnimations;
import ttv.migami.jeg.client.render.gun.animated.AnimatedGunRenderer;
import ttv.migami.jeg.common.Gun;
import ttv.migami.jeg.common.ReloadType;
import ttv.migami.jeg.init.ModItems;
import ttv.migami.jeg.init.ModSounds;
import ttv.migami.jeg.init.ModSyncedDataKeys;
import ttv.migami.jeg.item.GunItem;
import ttv.migami.jeg.item.attachment.IAttachment;
import ttv.migami.jeg.network.PacketHandler;
import ttv.migami.jeg.network.message.C2SMessageCasing;
import ttv.migami.jeg.network.message.C2SMessageGunLoaded;
import ttv.migami.jeg.network.message.C2SMessageGunUnjammed;
import ttv.migami.jeg.util.GunEnchantmentHelper;

public class AnimatedGunItem
extends GunItem
implements GeoAnimatable,
GeoItem {
    private final AnimatableInstanceCache cache = new SingletonAnimatableInstanceCache((GeoAnimatable)this);
    private final String gunID;
    private final SoundEvent reloadSoundMagOut;
    private final SoundEvent reloadSoundMagIn;
    private final SoundEvent reloadSoundEnd;
    private final SoundEvent ejectorSoundPull;
    private final SoundEvent ejectorSoundRelease;
    private int drawTick = 0;
    private boolean drawn = false;
    private int heartBeat = 60;

    public AnimatedGunItem(Item.Properties properties, String path, SoundEvent reloadSoundMagOut, SoundEvent reloadSoundMagIn, SoundEvent reloadSoundEnd, SoundEvent ejectorSoundPull, SoundEvent ejectorSoundRelease) {
        super(properties);
        this.gunID = path;
        this.reloadSoundMagOut = reloadSoundMagOut;
        this.reloadSoundMagIn = reloadSoundMagIn;
        this.reloadSoundEnd = reloadSoundEnd;
        this.ejectorSoundPull = ejectorSoundPull;
        this.ejectorSoundRelease = ejectorSoundRelease;
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!(entity instanceof Player)) {
            return;
        }
        CompoundTag nbtCompound = stack.m_41784_();
        if (!nbtCompound.m_128425_("GeckoLibID", 99) && world instanceof ServerLevel) {
            nbtCompound.m_128356_("GeckoLibID", AnimatableIdCache.getFreeId((ServerLevel)((ServerLevel)world)));
        }
        long id = GeoItem.getId((ItemStack)stack);
        AnimationController animationController = (AnimationController)this.getAnimatableInstanceCache().getManagerForId(id).getAnimationControllers().get("controller");
        if (stack.m_41720_() == ModItems.FINGER_GUN.get() && !stack.m_41783_().m_128471_("IgnoreAmmo")) {
            stack.m_41784_().m_128379_("IgnoreAmmo", true);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_21205_().m_41720_() == ModItems.HYPERSONIC_CANNON.get()) {
                --this.heartBeat;
                if (this.heartBeat == 0) {
                    player.m_5496_(SoundEvents.f_215762_, 0.3f, 1.0f);
                    this.heartBeat = 30;
                }
                if (this.heartBeat < 0) {
                    this.heartBeat = 30;
                }
            }
            this.updateBooleanTag(nbtCompound, "IsDrawing", nbtCompound.m_128471_("IsDrawn"));
            if (nbtCompound.m_128471_("IsDrawing") && nbtCompound.m_128451_("DrawnTick") < 15) {
                ++this.drawTick;
                nbtCompound.m_128405_("DrawnTick", this.drawTick);
            }
            if (id == GeoItem.getId((ItemStack)player.m_21205_())) {
                if (!nbtCompound.m_128471_("IsDrawn")) {
                    nbtCompound.m_128379_("IsDrawn", true);
                }
                boolean isSprinting = player.m_20142_();
                boolean isAiming = (Boolean)ModSyncedDataKeys.AIMING.getValue((Entity)player);
                this.updateBooleanTag(nbtCompound, "IsAiming", isAiming);
                this.updateBooleanTag(nbtCompound, "IsRunning", isSprinting);
                if (nbtCompound.m_128471_("IsDrawing") && nbtCompound.m_128451_("DrawnTick") < 15 && ((Boolean)Config.COMMON.gameplay.drawAnimation.get()).booleanValue()) {
                    this.handleDrawingState(nbtCompound, (AnimationController<GeoAnimatable>)animationController, stack);
                }
                if (!(nbtCompound.m_128451_("DrawnTick") < 15 || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "draw") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "jam") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "melee") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "bayonet") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "shoot") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "aim_shoot"))) {
                    if (nbtCompound.m_128471_("IsReloading") && !this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_stop")) {
                        this.handleReloadingState(nbtCompound, (AnimationController<GeoAnimatable>)animationController, stack);
                    } else if (nbtCompound.m_128471_("IsAiming")) {
                        this.handleAimingState(nbtCompound, (AnimationController<GeoAnimatable>)animationController);
                    } else if (nbtCompound.m_128471_("IsRunning") && !this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "inspect") && !this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_stop")) {
                        this.handleRunningState((AnimationController<GeoAnimatable>)animationController, isAiming, player);
                    } else if (!(this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "inspect") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "melee") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "bayonet") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "shoot") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "aim_shoot") || this.isAnimationPlaying((AnimationController<GeoAnimatable>)animationController, "reload_stop"))) {
                        animationController.tryTriggerAnimation("idle");
                    }
                    if (!selected) {
                        animationController.tryTriggerAnimation("idle");
                    }
                }
            } else if (GeoItem.getId((ItemStack)player.m_21205_()) != id) {
                if (nbtCompound.m_128471_("IsDrawn")) {
                    nbtCompound.m_128473_("IsDrawn");
                    nbtCompound.m_128473_("DrawnTick");
                    this.drawTick = 0;
                }
                animationController.tryTriggerAnimation("idle");
            }
        }
    }

    private boolean isAnimationPlaying(AnimationController<GeoAnimatable> animationController, String animationName) {
        return animationController.getCurrentAnimation() != null && animationController.getCurrentAnimation().animation().name().matches(animationName);
    }

    private void updateBooleanTag(CompoundTag nbt, String key, boolean value) {
        if (value) {
            nbt.m_128379_(key, true);
        } else {
            nbt.m_128473_(key);
        }
    }

    private void handleJammedState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController, ItemStack stack) {
        if (GunEnchantmentHelper.getQuickHands(stack) == 2) {
            animationController.setAnimationSpeed(1.75);
        } else if (GunEnchantmentHelper.getQuickHands(stack) == 1) {
            animationController.setAnimationSpeed(1.25);
        }
        if (GunEnchantmentHelper.getQuickHands(stack) == 0) {
            animationController.setAnimationSpeed(1.0);
        }
        if (nbt.m_128471_("IsJammed") && !this.isAnimationPlaying(animationController, "draw")) {
            animationController.tryTriggerAnimation("jam");
        }
        nbt.m_128473_("IsShooting");
        nbt.m_128473_("IsInspecting");
    }

    private void handleDrawingState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController, ItemStack stack) {
        if (GunEnchantmentHelper.getQuickHands(stack) == 2) {
            animationController.setAnimationSpeed(1.75);
        } else if (GunEnchantmentHelper.getQuickHands(stack) == 1) {
            animationController.setAnimationSpeed(1.25);
        }
        if (GunEnchantmentHelper.getQuickHands(stack) == 0) {
            animationController.setAnimationSpeed(1.0);
        }
        if (nbt.m_128451_("DrawnTick") < 15) {
            animationController.tryTriggerAnimation("draw");
        }
        nbt.m_128473_("IsShooting");
        nbt.m_128473_("IsInspecting");
    }

    private void handleReloadingState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController, ItemStack stack) {
        Gun modifiedGun = ((GunItem)stack.m_41720_()).getModifiedGun(stack);
        if (GunEnchantmentHelper.getQuickHands(stack) == 2) {
            animationController.setAnimationSpeed(1.75);
        } else if (GunEnchantmentHelper.getQuickHands(stack) == 1) {
            animationController.setAnimationSpeed(1.25);
        }
        if (GunEnchantmentHelper.getQuickHands(stack) == 0) {
            animationController.setAnimationSpeed(1.0);
        }
        if (modifiedGun.getReloads().getReloadType() == ReloadType.MANUAL) {
            animationController.tryTriggerAnimation("reload_start");
        } else if (stack.m_41720_() == ModItems.INFANTRY_RIFLE.get() && Gun.hasAttachmentEquipped(stack, IAttachment.Type.MAGAZINE)) {
            animationController.tryTriggerAnimation("reload_alt");
        } else {
            animationController.tryTriggerAnimation("reload");
        }
        nbt.m_128473_("IsShooting");
        nbt.m_128473_("IsInspecting");
    }

    private void handleAimingState(CompoundTag nbt, AnimationController<GeoAnimatable> animationController) {
        animationController.setAnimationSpeed(1.0);
        nbt.m_128473_("IsInspecting");
        animationController.tryTriggerAnimation("idle");
    }

    private void handleRunningState(AnimationController<GeoAnimatable> animationController, boolean isAiming, Player player) {
        animationController.setAnimationSpeed(1.0);
        if (!isAiming) {
            if (!(Gun.getAttachment(IAttachment.Type.BARREL, player.m_21205_()).m_41720_() instanceof SwordItem)) {
                animationController.tryTriggerAnimation("sprint");
            } else {
                animationController.tryTriggerAnimation("idle");
            }
        }
    }

    private void soundListener(SoundKeyframeEvent<AnimatedGunItem> gunItemSoundKeyframeEvent) {
        Player player = ClientUtils.getClientPlayer();
        if (player != null) {
            switch (gunItemSoundKeyframeEvent.getKeyframeData().getSound()) {
                case "rustle": {
                    player.m_5496_((SoundEvent)ModSounds.GUN_RUSTLE.get(), 1.0f, 1.0f);
                    break;
                }
                case "screw": {
                    player.m_5496_((SoundEvent)ModSounds.GUN_SCREW.get(), 1.0f, 1.0f);
                    break;
                }
                case "reload_mag_out": {
                    player.m_5496_(this.reloadSoundMagOut, 1.0f, 1.0f);
                    break;
                }
                case "reload_mag_in": {
                    player.m_5496_(this.reloadSoundMagIn, 1.0f, 1.0f);
                    break;
                }
                case "reload_end": {
                    player.m_5496_(this.reloadSoundEnd, 1.0f, 1.0f);
                    break;
                }
                case "ejector_pull": {
                    player.m_5496_(this.ejectorSoundPull, 1.0f, 1.0f);
                    break;
                }
                case "ejector_release": {
                    player.m_5496_(this.ejectorSoundRelease, 1.0f, 1.0f);
                }
            }
        }
    }

    private void particleListener(ParticleKeyframeEvent<AnimatedGunItem> gunItemParticleKeyframeEvent) {
        Player player = ClientUtils.getClientPlayer();
        if (player != null && player.m_21205_().m_41720_() instanceof AnimatedGunItem) {
            ItemStack itemStack = player.m_21205_();
            switch (gunItemParticleKeyframeEvent.getKeyframeData().getEffect()) {
                case "eject_casing": {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageCasing());
                    break;
                }
                case "loaded": {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageGunLoaded());
                    break;
                }
                case "unjam": {
                    PacketHandler.getPlayChannel().sendToServer((IMessage)new C2SMessageGunUnjammed());
                }
            }
        }
    }

    public boolean isPerspectiveAware() {
        return true;
    }

    @Override
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private AnimatedGunRenderer renderer;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new AnimatedGunRenderer(new ResourceLocation("jeg", AnimatedGunItem.this.gunID));
                }
                return this.renderer;
            }
        });
    }

    private PlayState predicate(AnimationState<AnimatedGunItem> event) {
        if (event.getController().getCurrentAnimation() == null || event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().tryTriggerAnimation("idle");
        }
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        AnimationController controller = new AnimationController((GeoAnimatable)this, "controller", 0, this::predicate).setSoundKeyframeHandler(this::soundListener).setParticleKeyframeHandler(this::particleListener).triggerableAnim("idle", GunAnimations.IDLE).triggerableAnim("shoot", GunAnimations.SHOOT).triggerableAnim("aim_shoot", GunAnimations.AIM_SHOOT).triggerableAnim("reload", GunAnimations.RELOAD).triggerableAnim("reload_alt", GunAnimations.RELOAD_ALT).triggerableAnim("reload_start", GunAnimations.RELOAD_START).triggerableAnim("reload_loop", GunAnimations.RELOAD_LOOP).triggerableAnim("reload_stop", GunAnimations.RELOAD_STOP).triggerableAnim("sprint", GunAnimations.SPRINT).triggerableAnim("melee", GunAnimations.MELEE).triggerableAnim("bayonet", GunAnimations.BAYONET).triggerableAnim("draw", GunAnimations.DRAW).triggerableAnim("inspect", GunAnimations.INSPECT).triggerableAnim("jam", GunAnimations.JAM);
        controllers.add(new AnimationController[]{controller});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

